/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.io.netty.handler.codec.string;

import cz.o2.proxima.cassandra.shaded.io.netty.buffer.ByteBufUtil;
import cz.o2.proxima.cassandra.shaded.io.netty.channel.ChannelHandler;
import cz.o2.proxima.cassandra.shaded.io.netty.channel.ChannelHandlerContext;
import cz.o2.proxima.cassandra.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        out.add(ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg), this.charset));
    }
}

