/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.io.netty.handler.ipfilter;

import cz.o2.proxima.cassandra.shaded.io.netty.channel.ChannelFuture;
import cz.o2.proxima.cassandra.shaded.io.netty.channel.ChannelFutureListener;
import cz.o2.proxima.cassandra.shaded.io.netty.channel.ChannelHandler;
import cz.o2.proxima.cassandra.shaded.io.netty.channel.ChannelHandlerContext;
import cz.o2.proxima.cassandra.shaded.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import cz.o2.proxima.cassandra.shaded.io.netty.util.internal.ConcurrentSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;

@ChannelHandler.Sharable
public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = new ConcurrentSet<InetAddress>();

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        final InetAddress remoteIp = remoteAddress.getAddress();
        if (!this.connected.add(remoteIp)) {
            return false;
        }
        ctx.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                UniqueIpFilter.this.connected.remove(remoteIp);
            }
        });
        return true;
    }
}

