/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import cz.o2.proxima.cassandra.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Strings;
import cz.o2.proxima.direct.cassandra.CqlFactory;
import cz.o2.proxima.direct.cassandra.Offsets;
import cz.o2.proxima.direct.cassandra.StringConverter;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.storage.UriUtil;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheableCqlFactory
implements CqlFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheableCqlFactory.class);
    private static final long serialVersionUID = 1L;
    private EntityDescriptor entity;
    private String tableName;
    @Nullable
    private String payloadCol;
    @Nullable
    transient Session current = null;
    protected long ttl = 0L;
    private final Map<AttributeDescriptor<?>, PreparedStatement> ingestCache;
    private final Map<AttributeDescriptor<?>, PreparedStatement> deleteCache;
    private final Map<AttributeDescriptor<?>, PreparedStatement> deleteWildcardCache;
    private final Map<AttributeDescriptor<?>, PreparedStatement> getCache;
    private final Map<AttributeDescriptor<?>, PreparedStatement> listCache = CacheableCqlFactory.createCache(1000L);
    @Nullable
    private transient PreparedStatement listEntities;
    @Nullable
    private transient PreparedStatement fetchToken;
    @Nullable
    private transient PreparedStatement listAllAttributes;

    private static Map<AttributeDescriptor<?>, PreparedStatement> createCache(final long maxSize) {
        return new LinkedHashMap<AttributeDescriptor<?>, PreparedStatement>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<AttributeDescriptor<?>, PreparedStatement> eldest) {
                return (long)this.size() > maxSize;
            }

            @Override
            public PreparedStatement get(Object key) {
                PreparedStatement ret = (PreparedStatement)super.get(key);
                if (ret != null) {
                    this.remove(key);
                    this.put((AttributeDescriptor)key, ret);
                }
                return ret;
            }
        };
    }

    protected CacheableCqlFactory() {
        this.getCache = CacheableCqlFactory.createCache(1000L);
        this.deleteWildcardCache = CacheableCqlFactory.createCache(1000L);
        this.deleteCache = CacheableCqlFactory.createCache(1000L);
        this.ingestCache = CacheableCqlFactory.createCache(1000L);
    }

    @Override
    public final void setup(EntityDescriptor entity, URI uri, StringConverter<?> converter) {
        Map parsed;
        this.entity = entity;
        this.tableName = uri.getPath();
        while (this.tableName.endsWith("/")) {
            this.tableName = this.tableName.substring(0, this.tableName.length() - 1);
        }
        if (this.tableName.length() <= 1) {
            throw new IllegalArgumentException("Invalid path in cassandra URI " + uri + ". The path represents name of table (including keyspace)");
        }
        this.tableName = this.tableName.substring(1);
        if (!Strings.isNullOrEmpty(uri.getQuery())) {
            parsed = UriUtil.parseQuery((URI)uri);
            this.payloadCol = (String)parsed.get("data");
        } else {
            parsed = Collections.emptyMap();
        }
        String tmp = (String)parsed.get("ttl");
        if (tmp != null) {
            this.ttl = Long.parseLong(tmp);
        }
        try {
            this.setup(parsed, converter);
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Cannot setup URI " + uri, ex);
        }
    }

    protected void setup(Map<String, String> query, StringConverter<?> converter) {
    }

    protected PreparedStatement getPreparedStatement(Session session, StreamElement what) {
        if (what.isDelete()) {
            PreparedStatement cached;
            if (what.isDeleteWildcard()) {
                cached = this.deleteWildcardCache.get(what.getAttributeDescriptor());
                if (cached == null) {
                    cached = CacheableCqlFactory.prepare(session, this.createDeleteWildcardStatement(what));
                    this.deleteWildcardCache.put(what.getAttributeDescriptor(), cached);
                }
            } else {
                cached = this.deleteCache.get(what.getAttributeDescriptor());
                if (cached == null) {
                    cached = CacheableCqlFactory.prepare(session, this.createDeleteStatement(what));
                    this.deleteCache.put(what.getAttributeDescriptor(), cached);
                }
            }
            return cached;
        }
        PreparedStatement cached = this.ingestCache.get(what.getAttributeDescriptor());
        if (cached == null) {
            cached = CacheableCqlFactory.prepare(session, this.createInsertStatement(what));
            this.ingestCache.put(what.getAttributeDescriptor(), cached);
        }
        return cached;
    }

    protected PreparedStatement getPreparedGetStatement(Session session, String attribute, AttributeDescriptor<?> desc) {
        return this.getCache.computeIfAbsent(desc, k -> {
            PreparedStatement prepared = CacheableCqlFactory.prepare(session, this.createGetStatement(attribute, desc));
            log.info("Prepared statement {}", (Object)prepared);
            return prepared;
        });
    }

    protected PreparedStatement getPreparedListStatement(Session session, AttributeDescriptor<?> wildcardAttribute) {
        return this.listCache.computeIfAbsent(wildcardAttribute, k -> CacheableCqlFactory.prepare(session, this.createListStatement(wildcardAttribute)));
    }

    protected PreparedStatement getPreparedListAllStatement(Session session) {
        if (this.listAllAttributes == null) {
            this.listAllAttributes = CacheableCqlFactory.prepare(session, this.createListAllStatement(session));
        }
        return this.listAllAttributes;
    }

    protected abstract String createInsertStatement(StreamElement var1);

    protected abstract String createDeleteStatement(StreamElement var1);

    protected abstract String createDeleteWildcardStatement(StreamElement var1);

    protected abstract String createGetStatement(String var1, AttributeDescriptor<?> var2);

    protected abstract String createListStatement(AttributeDescriptor<?> var1);

    protected abstract String createListEntitiesStatement();

    protected abstract String createFetchTokenStatement();

    protected abstract String createListAllStatement(Session var1);

    protected void clearCache() {
        this.ingestCache.clear();
        this.deleteCache.clear();
        this.getCache.clear();
        this.listCache.clear();
        this.listEntities = null;
        this.fetchToken = null;
        this.listAllAttributes = null;
    }

    @VisibleForTesting
    String toUnderScore(String what) {
        StringBuilder sb = new StringBuilder();
        for (char c : what.toCharArray()) {
            if (c == '.') {
                sb.append("_");
                continue;
            }
            if (!Character.isUpperCase(c)) {
                sb.append(c);
                continue;
            }
            sb.append("_").append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    String toPayloadCol(AttributeDescriptor<?> attr) {
        if (this.payloadCol != null) {
            return this.payloadCol;
        }
        return attr.toAttributePrefix(false);
    }

    @Override
    public BoundStatement getListEntitiesStatement(Offsets.Token offset, int limit, Session session) {
        if (this.listEntities == null) {
            this.listEntities = CacheableCqlFactory.prepare(session, this.createListEntitiesStatement());
        }
        int n = limit = limit < 0 ? Integer.MAX_VALUE : limit;
        if (offset == null) {
            return this.listEntities.bind(Long.MIN_VALUE, limit);
        }
        return this.listEntities.bind(offset.getToken(), limit);
    }

    @Override
    public BoundStatement getFetchTokenStatement(String key, Session session) {
        if (this.fetchToken == null) {
            this.fetchToken = CacheableCqlFactory.prepare(session, this.createFetchTokenStatement());
        }
        return this.fetchToken.bind(key);
    }

    void ensureSession(Session session) {
        if (this.current != session) {
            this.clearCache();
            this.current = session;
        }
    }

    static PreparedStatement prepare(Session session, String statement) {
        PreparedStatement ret = session.prepare(statement);
        log.info("Prepared statement {} as {}", (Object)statement, (Object)ret);
        return ret;
    }

    @Generated
    public EntityDescriptor getEntity() {
        return this.entity;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Nullable
    @Generated
    public Session getCurrent() {
        return this.current;
    }
}

