/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.direct.cassandra.CacheableCqlFactory;
import cz.o2.proxima.direct.cassandra.CassandraPartition;
import cz.o2.proxima.direct.cassandra.CqlFactory;
import cz.o2.proxima.direct.cassandra.Offsets;
import cz.o2.proxima.direct.cassandra.StringConverter;
import cz.o2.proxima.direct.randomaccess.KeyValue;
import cz.o2.proxima.direct.randomaccess.RandomOffset;
import cz.o2.proxima.io.serialization.shaded.com.google.protobuf.ByteString;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.storage.proto.Serialization;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCqlFactory
extends CacheableCqlFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCqlFactory.class);
    String primaryField;
    @Nullable
    String secondaryField;
    StringConverter<?> converter = StringConverter.getDefault();
    private Serializer serializer = new RawValueSerializer();
    boolean reversed = false;

    @Override
    protected void setup(Map<String, String> query, StringConverter<?> converter) {
        this.primaryField = query.get("primary");
        if (this.primaryField == null) {
            throw new IllegalArgumentException("Query does not contain `primary' parameter in query. This parameter specifies name of the field that is being used as primary key (or first part of a composite key).");
        }
        this.reversed = Optional.ofNullable(query.get("reversed")).map(Object::toString).map(Boolean::valueOf).orElse(false);
        this.secondaryField = query.get("secondary");
        this.converter = converter;
        String serializerVersion = Optional.ofNullable(query.get("serializer")).map(Object::toString).orElse("v1");
        Preconditions.checkArgument(serializerVersion.equals("v1") || serializerVersion.equals("v2"), "Unknown serializer %s, supported only v1 or v2", (Object)serializerVersion);
        this.serializer = serializerVersion.equals("v2") ? new V2Serializer() : this.serializer;
    }

    @Override
    public Optional<BoundStatement> getWriteStatement(StreamElement element, Session session) {
        this.ensureSession(session);
        if (element.isDelete()) {
            return this.elementDelete(element);
        }
        return this.elementInsert(element);
    }

    @Override
    public BoundStatement getReadStatement(String key, String attribute, AttributeDescriptor<?> desc, Session session) {
        this.ensureSession(session);
        PreparedStatement statement = this.getPreparedGetStatement(session, attribute, desc);
        if (desc.isWildcard()) {
            return statement.bind(key, this.toColVal(attribute));
        }
        return statement.bind(key);
    }

    @Override
    public BoundStatement getListStatement(String key, AttributeDescriptor<?> wildcard, @Nullable Offsets.Raw offset, int limit, Session session) {
        this.ensureSession(session);
        PreparedStatement statement = this.getPreparedListStatement(session, wildcard);
        Object startVal = null;
        if (offset != null) {
            startVal = this.toColVal(offset.getRaw());
        }
        if (startVal == null) {
            startVal = this.reversed ? this.converter.max() : this.converter.min();
        }
        return statement.bind(key, startVal, limit < 0 ? Integer.MAX_VALUE : limit);
    }

    private Optional<BoundStatement> elementInsert(StreamElement ingest) {
        PreparedStatement prepared = this.getPreparedStatement(this.current, ingest);
        if (ingest.getAttributeDescriptor().isWildcard()) {
            String attr = ingest.getAttribute();
            Object colVal = this.toColVal(attr);
            if (colVal != null) {
                BoundStatement bind = prepared.bind(ingest.getKey(), colVal, ByteBuffer.wrap(this.serializeValue(ingest)), ingest.getStamp() * 1000L);
                return Optional.of(bind);
            }
            return Optional.empty();
        }
        BoundStatement bind = prepared.bind(ingest.getKey(), ByteBuffer.wrap(this.serializeValue(ingest)), ingest.getStamp() * 1000L);
        return Optional.of(bind);
    }

    private Optional<BoundStatement> elementDelete(StreamElement ingest) {
        PreparedStatement prepared = this.getPreparedStatement(this.current, ingest);
        if (!ingest.isDeleteWildcard() && ingest.getAttributeDescriptor().isWildcard()) {
            String attr = ingest.getAttribute();
            Object colVal = this.toColVal(attr);
            return Optional.of(prepared.bind(ingest.getStamp() * 1000L, colVal, ingest.getKey()));
        }
        return Optional.of(prepared.bind(ingest.getStamp() * 1000L, ingest.getKey()));
    }

    @Override
    protected String createInsertStatement(StreamElement element) {
        if (element.getAttributeDescriptor().isWildcard()) {
            String colName = this.toColName(element.getAttributeDescriptor());
            return String.format("INSERT INTO %s (%s, %s, %s) VALUES (?, ?, ?) USING TIMESTAMP ?%s", this.getTableName(), this.primaryField, this.toUnderScore(colName), this.toPayloadCol(element.getAttributeDescriptor()), this.ttl > 0L ? " AND TTL " + this.ttl : "");
        }
        return String.format("INSERT INTO %s (%s, %s) VALUES (?, ?) USING TIMESTAMP ?%s", this.getTableName(), this.primaryField, this.toUnderScore(element.getAttribute()), this.ttl > 0L ? " AND TTL " + this.ttl : "");
    }

    @Override
    protected String createDeleteStatement(StreamElement element) {
        if (element.getAttributeDescriptor().isWildcard()) {
            String colName = this.toColName(element.getAttributeDescriptor());
            return String.format("DELETE %s FROM %s USING TIMESTAMP ? WHERE %s=? AND %s=?", this.toPayloadCol(element.getAttributeDescriptor()), this.getTableName(), this.toUnderScore(colName), this.primaryField);
        }
        return String.format("DELETE %s FROM %s USING TIMESTAMP ? WHERE %s=?", this.toUnderScore(element.getAttribute()), this.getTableName(), this.primaryField);
    }

    @Override
    protected String createDeleteWildcardStatement(StreamElement what) {
        return String.format("DELETE FROM %s USING TIMESTAMP ? WHERE %s=?", this.getTableName(), this.primaryField);
    }

    @Override
    protected String createGetStatement(String attribute, AttributeDescriptor<?> desc) {
        if (desc.isWildcard()) {
            String colName = this.toColName(desc);
            return String.format("SELECT %s FROM %s WHERE %s=? AND %s=?", this.toPayloadCol(desc), this.getTableName(), this.primaryField, this.toUnderScore(colName));
        }
        return String.format("SELECT %s FROM %s WHERE %s=?", this.toUnderScore(attribute), this.getTableName(), this.primaryField);
    }

    @Override
    protected String createListStatement(AttributeDescriptor<?> attr) {
        String colName = this.toColName(attr);
        String dataCol = this.toUnderScore(colName);
        return String.format("SELECT %s, %s FROM %s WHERE %s=? AND %s%s? LIMIT ?", dataCol, this.toPayloadCol(attr), this.getTableName(), this.primaryField, dataCol, this.reversed ? "<" : ">");
    }

    private byte[] serializeValue(StreamElement ingest) {
        return this.serializer.asCellBytes(ingest);
    }

    private String toColName(AttributeDescriptor<?> desc) {
        if (this.secondaryField == null) {
            return desc.toAttributePrefix(false);
        }
        return this.secondaryField;
    }

    @Nullable
    private Object toColVal(String attr) {
        int dotPos = attr.lastIndexOf(46);
        String colVal = "";
        if (dotPos > 0 && dotPos < attr.length() - 1) {
            colVal = attr.substring(dotPos + 1);
        }
        return this.converter.fromString(colVal);
    }

    @Override
    protected String createListEntitiesStatement() {
        return String.format("SELECT %s, token(%s) FROM %s WHERE token(%s) > ? LIMIT ?", this.primaryField, this.primaryField, this.getTableName(), this.primaryField);
    }

    @Override
    protected String createFetchTokenStatement() {
        return String.format("SELECT token(%s) FROM %s WHERE %s=?", this.primaryField, this.getTableName(), this.primaryField);
    }

    @Override
    protected String createListAllStatement(Session session) {
        throw new UnsupportedOperationException("Unsupported. See https://github.com/O2-Czech-Republic/proxima-platform/issues/67");
    }

    @Override
    public Statement scanPartition(List<AttributeDescriptor<?>> attributes, CassandraPartition partition, Session session) {
        StringBuilder columns = new StringBuilder();
        String comma = "";
        for (AttributeDescriptor<?> a : attributes) {
            columns.append(comma);
            columns.append(this.toUnderScore(this.toColName(a)));
            comma = ", ";
            if (a.isWildcard()) {
                columns.append(comma);
                columns.append(this.toUnderScore(this.toPayloadCol(a)));
            }
            comma = ", ";
        }
        String query = String.format("SELECT %s, %s FROM %s WHERE token(%s) >= %d AND token(%s) %s %d", this.primaryField, columns, this.getTableName(), this.primaryField, partition.getTokenStart(), this.primaryField, partition.isEndInclusive() ? "<=" : "<", partition.getTokenEnd());
        log.info("Scanning partition with query {}", (Object)query);
        return new SimpleStatement(query);
    }

    @Override
    public <T> KeyValue<T> toKeyValue(EntityDescriptor entityDescriptor, AttributeDescriptor<T> attributeDescriptor, String key, String attribute, long stamp, RandomOffset offset, byte[] serializedValue) {
        return this.serializer.fromCellBytes(entityDescriptor, attributeDescriptor, key, attribute, stamp, offset, serializedValue);
    }

    @Override
    public <T> CqlFactory.KvIterable<T> getListAllStatement(String key, Offsets.Raw offset, int limit, Session session) {
        throw new UnsupportedOperationException("Unsupported. See https://github.com/O2-Czech-Republic/proxima-platform/issues/67");
    }

    private static class V2Serializer
    implements Serializer {
        private V2Serializer() {
        }

        @Override
        public byte[] asCellBytes(StreamElement element) {
            return Serialization.Cell.newBuilder().setValue(ByteString.copyFrom(element.getValue())).setSeqId(element.hasSequentialId() ? element.getSequentialId() : 0L).build().toByteArray();
        }

        @Override
        public <T> KeyValue<T> fromCellBytes(EntityDescriptor entityDescriptor, AttributeDescriptor<T> attributeDescriptor, String key, String attribute, long stamp, RandomOffset offset, byte[] serializedValue) {
            Serialization.Cell cell = (Serialization.Cell)ExceptionUtils.uncheckedFactory((ExceptionUtils.ThrowingFactory & Serializable)() -> Serialization.Cell.parseFrom(serializedValue));
            if (cell.getSeqId() > 0L) {
                return KeyValue.of((EntityDescriptor)entityDescriptor, attributeDescriptor, (long)cell.getSeqId(), (String)key, (String)attribute, (RandomOffset)offset, (byte[])cell.getValue().toByteArray(), (long)stamp);
            }
            return KeyValue.of((EntityDescriptor)entityDescriptor, attributeDescriptor, (String)key, (String)attribute, (RandomOffset)offset, (byte[])cell.getValue().toByteArray(), (long)stamp);
        }
    }

    private static class RawValueSerializer
    implements Serializer {
        private RawValueSerializer() {
        }

        @Override
        public byte[] asCellBytes(StreamElement element) {
            return element.getValue();
        }

        @Override
        public <T> KeyValue<T> fromCellBytes(EntityDescriptor entityDescriptor, AttributeDescriptor<T> attributeDescriptor, String key, String attribute, long stamp, RandomOffset offset, byte[] serializedValue) {
            return KeyValue.of((EntityDescriptor)entityDescriptor, attributeDescriptor, (String)key, (String)attribute, (RandomOffset)offset, (byte[])serializedValue, (long)stamp);
        }
    }

    static interface Serializer
    extends Serializable {
        public byte[] asCellBytes(StreamElement var1);

        public <T> KeyValue<T> fromCellBytes(EntityDescriptor var1, AttributeDescriptor<T> var2, String var3, String var4, long var5, RandomOffset var7, byte[] var8);
    }
}

