/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import cz.o2.proxima.direct.cassandra.CacheableCqlFactory;
import cz.o2.proxima.direct.cassandra.CassandraPartition;
import cz.o2.proxima.direct.cassandra.CqlFactory;
import cz.o2.proxima.direct.cassandra.Offsets;
import cz.o2.proxima.direct.randomaccess.KeyValue;
import cz.o2.proxima.direct.randomaccess.RandomOffset;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.util.Pair;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformingCqlFactory<T extends Serializable>
extends CacheableCqlFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransformingCqlFactory.class);
    private static final long serialVersionUID = 1L;
    private final UnaryFunction<StreamElement, T> parser;
    private final List<String> columns;
    private final List<UnaryFunction<Pair<String, T>, Object>> extractors;
    private final UnaryFunction<T, Boolean> filter;

    protected TransformingCqlFactory(UnaryFunction<StreamElement, T> parser, List<String> columns, List<UnaryFunction<Pair<String, T>, Object>> extractors) {
        this(parser, columns, extractors, (UnaryFunction & Serializable)e -> true);
    }

    protected TransformingCqlFactory(UnaryFunction<StreamElement, T> parser, List<String> columns, List<UnaryFunction<Pair<String, T>, Object>> extractors, UnaryFunction<T, Boolean> filter) {
        this.parser = Objects.requireNonNull(parser);
        this.columns = Objects.requireNonNull(columns);
        this.extractors = Objects.requireNonNull(extractors);
        if (this.columns.size() != this.extractors.size() || this.columns.isEmpty()) {
            throw new IllegalArgumentException("Pass two non-empty same length lists");
        }
        this.filter = Objects.requireNonNull(filter);
    }

    @Override
    protected String createDeleteStatement(StreamElement ingest) {
        throw new UnsupportedOperationException("Cannot delete by instance of " + this.getClass());
    }

    @Override
    protected String createDeleteWildcardStatement(StreamElement what) {
        throw new UnsupportedOperationException("Cannot delete by instance of " + this.getClass());
    }

    @Override
    protected String createInsertStatement(StreamElement element) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("INSERT INTO %s (%s) VALUES (", this.getTableName(), String.join((CharSequence)", ", this.columns)));
        String comma = "";
        for (int i = 0; i < this.extractors.size(); ++i) {
            sb.append(comma);
            sb.append("?");
            comma = ", ";
        }
        sb.append(") USING TIMESTAMP ?");
        if (this.ttl > 0L) {
            sb.append(" AND TTL ");
            sb.append(this.ttl);
        }
        return sb.toString();
    }

    @Override
    public Optional<BoundStatement> getWriteStatement(StreamElement element, Session session) {
        this.ensureSession(session);
        if (element.isDelete()) {
            log.warn("Throwing away delete ingest specified for {}", (Object)this.getClass());
            return Optional.empty();
        }
        PreparedStatement statement = this.getPreparedStatement(session, element);
        Serializable parsed = (Serializable)this.parser.apply((Object)element);
        if (Boolean.TRUE.equals(this.filter.apply((Object)parsed))) {
            List<Object> values = this.extractors.stream().map(f -> f.apply((Object)Pair.of((Object)element.getKey(), (Object)parsed))).collect(Collectors.toList());
            if (values.stream().anyMatch(Objects::isNull)) {
                log.warn("Received null value while writing {}. Discarding.", (Object)element);
                return Optional.empty();
            }
            BoundStatement bound = statement.bind(values.toArray(new Object[values.size()]));
            bound.setLong(values.size(), element.getStamp() * 1000L);
            return Optional.of(bound);
        }
        log.debug("Ingest {} was filtered out.", (Object)element);
        return Optional.empty();
    }

    protected String createGetStatement(String attribute, AttributeDescriptor desc) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String createListStatement(AttributeDescriptor wildcard) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BoundStatement getReadStatement(String key, String attribute, AttributeDescriptor desc, Session session) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BoundStatement getListStatement(String key, AttributeDescriptor wildcard, Offsets.Raw offset, int limit, Session session) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    protected String createListEntitiesStatement() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    protected String createFetchTokenStatement() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Statement scanPartition(List<AttributeDescriptor<?>> attributes, CassandraPartition partition, Session session) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public <V> KeyValue<V> toKeyValue(EntityDescriptor entityDescriptor, AttributeDescriptor<V> attributeDescriptor, String key, String attribute, long stamp, RandomOffset offset, byte[] serializedValue) {
        return KeyValue.of((EntityDescriptor)entityDescriptor, attributeDescriptor, (String)key, (String)attribute, (RandomOffset)offset, (byte[])serializedValue, (long)stamp);
    }

    @Override
    protected String createListAllStatement(Session session) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public <T> CqlFactory.KvIterable<T> getListAllStatement(String key, Offsets.Raw offset, int limit, Session session) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

