/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.elasticsearch;

import cz.o2.proxima.elasticsearch.shaded.com.google.gson.JsonObject;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.storage.StreamElement;
import java.io.Serializable;
import java.util.Optional;

public interface DocumentFormatter
extends Serializable {
    public String toJson(StreamElement var1);

    default public String toKey(StreamElement element) {
        return element.getKey() + ":" + element.getAttribute();
    }

    public static class Default
    implements DocumentFormatter {
        @Override
        public String toJson(StreamElement element) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("key", element.getKey());
            jsonObject.addProperty("entity", element.getEntityDescriptor().getName());
            jsonObject.addProperty("attribute", element.getAttribute());
            jsonObject.addProperty("timestamp", element.getStamp());
            jsonObject.addProperty("uuid", element.getUuid());
            jsonObject.addProperty("updated_at", System.currentTimeMillis());
            Optional data = element.getParsed();
            if (data.isPresent()) {
                AttributeDescriptor attributeDescriptor = element.getAttributeDescriptor();
                String dataJson = attributeDescriptor.getValueSerializer().asJsonValue(data.get());
                jsonObject.addProperty("data", "${data}");
                return jsonObject.toString().replace("\"${data}\"", dataJson);
            }
            return jsonObject.toString();
        }
    }
}

