/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.direct.commitlog.CommitLogReader;
import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.core.DataAccessor;
import cz.o2.proxima.direct.elasticsearch.DocumentFormatter;
import cz.o2.proxima.direct.elasticsearch.ElasticsearchClients;
import cz.o2.proxima.direct.elasticsearch.ElasticsearchWriter;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.AbstractStorage;
import cz.o2.proxima.util.Classpath;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchAccessor
extends AbstractStorage.SerializableAbstractStorage
implements DataAccessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchAccessor.class);
    private static final long serialVersionUID = 1L;
    private static final String CFG_PREFIX = "elasticsearch.";
    static final String DEFAULT_SCHEME = "http";
    static final int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    static final int DEFAULT_CONNECTION_REQUEST_MS = 10000;
    static final int DEFAULT_SOCKET_TIMEOUT_MS = 60000;
    static final int DEFAULT_CONCURRENT_REQUESTS = 1;
    static final int DEFAULT_BATCH_SIZE = 100;
    static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    static final int DEFAULT_BULK_SIZE_MB = 10;
    private final Map<String, Object> cfg;
    private final String scheme;
    private final String indexName;
    private final int connectTimeoutMs;
    private final int connectionRequestTimeoutMs;
    private final int socketTimeoutMs;
    private final int concurrentRequests;
    private final int batchSize;
    private final String keystoreType;
    private final String keystorePath;
    private final String keystorePassword;
    private final String truststorePath;
    private final String truststorePassword;
    private final DocumentFormatter documentFormatter;
    private final int flushIntervalMs;
    private final int bulkSizeMb;

    public ElasticsearchAccessor(EntityDescriptor entityDesc, URI uri, Map<String, Object> cfg) {
        super(entityDesc, uri);
        this.cfg = cfg;
        this.scheme = this.getStringConfig("scheme", DEFAULT_SCHEME);
        this.connectTimeoutMs = this.getIntConfig("connect-timeout-ms", 5000);
        this.connectionRequestTimeoutMs = this.getIntConfig("connection-request-timeout-ms", 10000);
        this.socketTimeoutMs = this.getIntConfig("socket-timeout-ms", 60000);
        this.concurrentRequests = this.getIntConfig("concurrent-batch-requests", 1);
        this.batchSize = this.getIntConfig("batch-size", 100);
        this.keystoreType = this.getStringConfig("keystore-type", DEFAULT_KEYSTORE_TYPE);
        this.keystorePath = this.getStringConfig("keystore-path");
        this.keystorePassword = this.getStringConfig("keystore-password");
        this.truststorePath = this.getStringConfig("truststore-path");
        this.truststorePassword = this.getStringConfig("truststore-password");
        this.indexName = ElasticsearchAccessor.parseIndexName(uri);
        this.documentFormatter = (DocumentFormatter)Classpath.newInstance((String)this.getStringConfig("document-formatter", DocumentFormatter.Default.class.getName()), DocumentFormatter.class);
        this.flushIntervalMs = this.getIntConfig("flush-interval-ms", 0);
        this.bulkSizeMb = this.getIntConfig("bulk-size-mb", 10);
    }

    @VisibleForTesting
    public static String parseIndexName(URI uri) {
        String path = uri.getPath();
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() <= 1) {
            throw new IllegalArgumentException("Invalid path in elastic URI " + uri + ". The path represents name of index");
        }
        return path.substring(1);
    }

    public Optional<AttributeWriterBase> getWriter(Context context) {
        if (this.getUri().getScheme().startsWith("elastic")) {
            return Optional.of(new ElasticsearchWriter(this));
        }
        return Optional.empty();
    }

    public Optional<CommitLogReader> getCommitLogReader(Context context) {
        return Optional.empty();
    }

    public RestHighLevelClient getRestHighLevelClient() {
        return new RestHighLevelClient(ElasticsearchClients.createBuilder(new ElasticsearchClients.Configuration(this.getScheme(), this.getUri().getAuthority(), this.getConnectTimeoutMs(), this.getSocketTimeoutMs(), this.getConnectionRequestTimeoutMs(), this.getKeystoreType(), this.getKeystorePath(), this.getKeystorePassword(), this.getTruststorePath(), this.getTruststorePassword())));
    }

    private int getIntConfig(String key, int defaultValue) {
        return Integer.parseInt(this.cfg.getOrDefault(CFG_PREFIX + key, defaultValue).toString());
    }

    private String getStringConfig(String key) {
        return this.getStringConfig(key, "");
    }

    private String getStringConfig(String key, String defaultValue) {
        return this.cfg.getOrDefault(CFG_PREFIX + key, defaultValue).toString();
    }

    @Nullable
    public TimeValue getFlushInterval() {
        return this.flushIntervalMs > 0 ? TimeValue.timeValueMillis(this.flushIntervalMs) : null;
    }

    @Generated
    public Map<String, Object> getCfg() {
        return this.cfg;
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    @Generated
    public int getConnectionRequestTimeoutMs() {
        return this.connectionRequestTimeoutMs;
    }

    @Generated
    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @Generated
    public int getConcurrentRequests() {
        return this.concurrentRequests;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public String getKeystoreType() {
        return this.keystoreType;
    }

    @Generated
    public String getKeystorePath() {
        return this.keystorePath;
    }

    @Generated
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Generated
    public String getTruststorePath() {
        return this.truststorePath;
    }

    @Generated
    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    @Generated
    public DocumentFormatter getDocumentFormatter() {
        return this.documentFormatter;
    }

    @Generated
    public int getBulkSizeMb() {
        return this.bulkSizeMb;
    }
}

