/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.HttpHost;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.ssl.SSLContextBuilder;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.ssl.SSLContexts;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchClients {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchClients.class);

    public static RestClientBuilder createBuilder(Configuration config) {
        RestClientBuilder builder = RestClient.builder(ElasticsearchClients.parseHosts(config.hostnames, config.getScheme())).setRequestConfigCallback(ElasticsearchClients.createRequestConfigCallback(config));
        if ("https".equalsIgnoreCase(config.getScheme())) {
            builder.setHttpClientConfigCallback(ElasticsearchClients.createConfigurationCallback(config));
        }
        return builder;
    }

    public static RestClient create(Configuration config) {
        return ElasticsearchClients.createBuilder(config).build();
    }

    @VisibleForTesting
    static HttpHost[] parseHosts(String hostnames, String scheme) {
        List<HttpHost> httpHosts = Arrays.stream(hostnames.split(",")).map(p -> {
            String[] parts = p.split(":");
            if (parts.length == 1) {
                return new HttpHost(parts[0], 9200, scheme);
            }
            if (parts.length == 2) {
                return new HttpHost(parts[0], Integer.parseInt(parts[1]), scheme);
            }
            throw new IllegalArgumentException("Invalid address " + p);
        }).collect(Collectors.toList());
        HttpHost[] hostsArray = new HttpHost[httpHosts.size()];
        return httpHosts.toArray(hostsArray);
    }

    private static RestClientBuilder.RequestConfigCallback createRequestConfigCallback(Configuration config) {
        return requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(config.getConnectTimeoutMs()).setSocketTimeout(config.getSocketTimeoutMs()).setConnectionRequestTimeout(config.getConnectionRequestTimeoutMs());
    }

    @VisibleForTesting
    static RestClientBuilder.HttpClientConfigCallback createConfigurationCallback(Configuration config) {
        try {
            SSLContextBuilder sslBuilder = SSLContexts.custom();
            ElasticsearchClients.loadClientKeyStore(sslBuilder, config);
            ElasticsearchClients.loadTrustStore(sslBuilder, config);
            SSLContext sslContext = sslBuilder.build();
            return httpClientBuilder -> httpClientBuilder.setSSLContext(sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Cannot initialize SSLContext", e);
        }
    }

    private static void loadClientKeyStore(SSLContextBuilder sslBuilder, Configuration config) {
        if (config.getKeystorePath().isEmpty()) {
            log.warn("No client keystore configured.");
            return;
        }
        try {
            String pass = config.getKeystorePassword().isEmpty() ? null : config.getKeystorePassword();
            log.info("Using keystore: {}, Password protected: {}", (Object)config.getKeystorePath(), (Object)(pass != null ? 1 : 0));
            KeyStore clientKeyStore = ElasticsearchClients.createKeyStore(config.getKeystorePath(), pass, config);
            sslBuilder.loadKeyMaterial(clientKeyStore, pass == null ? null : pass.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new IllegalArgumentException("Cannot load keystore: " + config.getKeystorePath(), e);
        }
    }

    private static void loadTrustStore(SSLContextBuilder sslBuilder, Configuration config) {
        if (config.getTruststorePath().isEmpty()) {
            log.info("No truststore configured.");
            return;
        }
        try {
            String pass = config.getTruststorePassword().isEmpty() ? null : config.getTruststorePassword();
            log.info("Using truststore: {}, Password protected: {}", (Object)config.getTruststorePath(), (Object)(pass != null ? 1 : 0));
            KeyStore clientKeyStore = ElasticsearchClients.createKeyStore(config.getTruststorePath(), pass, config);
            sslBuilder.loadTrustMaterial(clientKeyStore, new TrustSelfSignedStrategy());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException("Cannot load truststore: " + config.getTruststorePath(), e);
        }
    }

    private static KeyStore createKeyStore(String keyStorePath, @Nullable String keyStorePassword, Configuration config) throws KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(config.getKeystoreType());
        File keyStoreFile = new File(keyStorePath);
        if (!keyStoreFile.exists()) {
            throw new IllegalArgumentException("Couldn't find file: " + keyStorePath);
        }
        char[] keyStorePasswordChars = keyStorePassword == null ? null : keyStorePassword.toCharArray();
        try (InputStream is = Files.newInputStream(keyStoreFile.toPath(), new OpenOption[0]);){
            keyStore.load(is, keyStorePasswordChars);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't load file: " + keyStorePath);
        }
        return keyStore;
    }

    private ElasticsearchClients() {
    }

    public static final class Configuration {
        private final String scheme;
        private final String hostnames;
        private final int connectTimeoutMs;
        private final int socketTimeoutMs;
        private final int connectionRequestTimeoutMs;
        private final String keystoreType;
        private final String keystorePath;
        private final String keystorePassword;
        private final String truststorePath;
        private final String truststorePassword;

        @Generated
        private static String $default$scheme() {
            return "http";
        }

        @Generated
        private static String $default$hostnames() {
            return "";
        }

        @Generated
        private static int $default$connectTimeoutMs() {
            return 5000;
        }

        @Generated
        private static int $default$socketTimeoutMs() {
            return 30000;
        }

        @Generated
        private static int $default$connectionRequestTimeoutMs() {
            return 10000;
        }

        @Generated
        private static String $default$keystoreType() {
            return "PKCS12";
        }

        @Generated
        private static String $default$keystorePath() {
            return "";
        }

        @Generated
        private static String $default$keystorePassword() {
            return "";
        }

        @Generated
        private static String $default$truststorePath() {
            return "";
        }

        @Generated
        private static String $default$truststorePassword() {
            return "";
        }

        @Generated
        Configuration(String scheme, String hostnames, int connectTimeoutMs, int socketTimeoutMs, int connectionRequestTimeoutMs, String keystoreType, String keystorePath, String keystorePassword, String truststorePath, String truststorePassword) {
            this.scheme = scheme;
            this.hostnames = hostnames;
            this.connectTimeoutMs = connectTimeoutMs;
            this.socketTimeoutMs = socketTimeoutMs;
            this.connectionRequestTimeoutMs = connectionRequestTimeoutMs;
            this.keystoreType = keystoreType;
            this.keystorePath = keystorePath;
            this.keystorePassword = keystorePassword;
            this.truststorePath = truststorePath;
            this.truststorePassword = truststorePassword;
        }

        @Generated
        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        @Generated
        public String getScheme() {
            return this.scheme;
        }

        @Generated
        public String getHostnames() {
            return this.hostnames;
        }

        @Generated
        public int getConnectTimeoutMs() {
            return this.connectTimeoutMs;
        }

        @Generated
        public int getSocketTimeoutMs() {
            return this.socketTimeoutMs;
        }

        @Generated
        public int getConnectionRequestTimeoutMs() {
            return this.connectionRequestTimeoutMs;
        }

        @Generated
        public String getKeystoreType() {
            return this.keystoreType;
        }

        @Generated
        public String getKeystorePath() {
            return this.keystorePath;
        }

        @Generated
        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        @Generated
        public String getTruststorePath() {
            return this.truststorePath;
        }

        @Generated
        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (this.getConnectTimeoutMs() != other.getConnectTimeoutMs()) {
                return false;
            }
            if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
                return false;
            }
            if (this.getConnectionRequestTimeoutMs() != other.getConnectionRequestTimeoutMs()) {
                return false;
            }
            String this$scheme = this.getScheme();
            String other$scheme = other.getScheme();
            if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
                return false;
            }
            String this$hostnames = this.getHostnames();
            String other$hostnames = other.getHostnames();
            if (this$hostnames == null ? other$hostnames != null : !this$hostnames.equals(other$hostnames)) {
                return false;
            }
            String this$keystoreType = this.getKeystoreType();
            String other$keystoreType = other.getKeystoreType();
            if (this$keystoreType == null ? other$keystoreType != null : !this$keystoreType.equals(other$keystoreType)) {
                return false;
            }
            String this$keystorePath = this.getKeystorePath();
            String other$keystorePath = other.getKeystorePath();
            if (this$keystorePath == null ? other$keystorePath != null : !this$keystorePath.equals(other$keystorePath)) {
                return false;
            }
            String this$keystorePassword = this.getKeystorePassword();
            String other$keystorePassword = other.getKeystorePassword();
            if (this$keystorePassword == null ? other$keystorePassword != null : !this$keystorePassword.equals(other$keystorePassword)) {
                return false;
            }
            String this$truststorePath = this.getTruststorePath();
            String other$truststorePath = other.getTruststorePath();
            if (this$truststorePath == null ? other$truststorePath != null : !this$truststorePath.equals(other$truststorePath)) {
                return false;
            }
            String this$truststorePassword = this.getTruststorePassword();
            String other$truststorePassword = other.getTruststorePassword();
            return !(this$truststorePassword == null ? other$truststorePassword != null : !this$truststorePassword.equals(other$truststorePassword));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getConnectTimeoutMs();
            result = result * 59 + this.getSocketTimeoutMs();
            result = result * 59 + this.getConnectionRequestTimeoutMs();
            String $scheme = this.getScheme();
            result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
            String $hostnames = this.getHostnames();
            result = result * 59 + ($hostnames == null ? 43 : $hostnames.hashCode());
            String $keystoreType = this.getKeystoreType();
            result = result * 59 + ($keystoreType == null ? 43 : $keystoreType.hashCode());
            String $keystorePath = this.getKeystorePath();
            result = result * 59 + ($keystorePath == null ? 43 : $keystorePath.hashCode());
            String $keystorePassword = this.getKeystorePassword();
            result = result * 59 + ($keystorePassword == null ? 43 : $keystorePassword.hashCode());
            String $truststorePath = this.getTruststorePath();
            result = result * 59 + ($truststorePath == null ? 43 : $truststorePath.hashCode());
            String $truststorePassword = this.getTruststorePassword();
            result = result * 59 + ($truststorePassword == null ? 43 : $truststorePassword.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ElasticsearchClients.Configuration(scheme=" + this.getScheme() + ", hostnames=" + this.getHostnames() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", connectionRequestTimeoutMs=" + this.getConnectionRequestTimeoutMs() + ", keystoreType=" + this.getKeystoreType() + ", keystorePath=" + this.getKeystorePath() + ", keystorePassword=" + this.getKeystorePassword() + ", truststorePath=" + this.getTruststorePath() + ", truststorePassword=" + this.getTruststorePassword() + ")";
        }

        @Generated
        public static class ConfigurationBuilder {
            @Generated
            private boolean scheme$set;
            @Generated
            private String scheme$value;
            @Generated
            private boolean hostnames$set;
            @Generated
            private String hostnames$value;
            @Generated
            private boolean connectTimeoutMs$set;
            @Generated
            private int connectTimeoutMs$value;
            @Generated
            private boolean socketTimeoutMs$set;
            @Generated
            private int socketTimeoutMs$value;
            @Generated
            private boolean connectionRequestTimeoutMs$set;
            @Generated
            private int connectionRequestTimeoutMs$value;
            @Generated
            private boolean keystoreType$set;
            @Generated
            private String keystoreType$value;
            @Generated
            private boolean keystorePath$set;
            @Generated
            private String keystorePath$value;
            @Generated
            private boolean keystorePassword$set;
            @Generated
            private String keystorePassword$value;
            @Generated
            private boolean truststorePath$set;
            @Generated
            private String truststorePath$value;
            @Generated
            private boolean truststorePassword$set;
            @Generated
            private String truststorePassword$value;

            @Generated
            ConfigurationBuilder() {
            }

            @Generated
            public ConfigurationBuilder scheme(String scheme) {
                this.scheme$value = scheme;
                this.scheme$set = true;
                return this;
            }

            @Generated
            public ConfigurationBuilder hostnames(String hostnames) {
                this.hostnames$value = hostnames;
                this.hostnames$set = true;
                return this;
            }

            @Generated
            public ConfigurationBuilder connectTimeoutMs(int connectTimeoutMs) {
                this.connectTimeoutMs$value = connectTimeoutMs;
                this.connectTimeoutMs$set = true;
                return this;
            }

            @Generated
            public ConfigurationBuilder socketTimeoutMs(int socketTimeoutMs) {
                this.socketTimeoutMs$value = socketTimeoutMs;
                this.socketTimeoutMs$set = true;
                return this;
            }

            @Generated
            public ConfigurationBuilder connectionRequestTimeoutMs(int connectionRequestTimeoutMs) {
                this.connectionRequestTimeoutMs$value = connectionRequestTimeoutMs;
                this.connectionRequestTimeoutMs$set = true;
                return this;
            }

            @Generated
            public ConfigurationBuilder keystoreType(String keystoreType) {
                this.keystoreType$value = keystoreType;
                this.keystoreType$set = true;
                return this;
            }

            @Generated
            public ConfigurationBuilder keystorePath(String keystorePath) {
                this.keystorePath$value = keystorePath;
                this.keystorePath$set = true;
                return this;
            }

            @Generated
            public ConfigurationBuilder keystorePassword(String keystorePassword) {
                this.keystorePassword$value = keystorePassword;
                this.keystorePassword$set = true;
                return this;
            }

            @Generated
            public ConfigurationBuilder truststorePath(String truststorePath) {
                this.truststorePath$value = truststorePath;
                this.truststorePath$set = true;
                return this;
            }

            @Generated
            public ConfigurationBuilder truststorePassword(String truststorePassword) {
                this.truststorePassword$value = truststorePassword;
                this.truststorePassword$set = true;
                return this;
            }

            @Generated
            public Configuration build() {
                String scheme$value = this.scheme$value;
                if (!this.scheme$set) {
                    scheme$value = Configuration.$default$scheme();
                }
                String hostnames$value = this.hostnames$value;
                if (!this.hostnames$set) {
                    hostnames$value = Configuration.$default$hostnames();
                }
                int connectTimeoutMs$value = this.connectTimeoutMs$value;
                if (!this.connectTimeoutMs$set) {
                    connectTimeoutMs$value = Configuration.$default$connectTimeoutMs();
                }
                int socketTimeoutMs$value = this.socketTimeoutMs$value;
                if (!this.socketTimeoutMs$set) {
                    socketTimeoutMs$value = Configuration.$default$socketTimeoutMs();
                }
                int connectionRequestTimeoutMs$value = this.connectionRequestTimeoutMs$value;
                if (!this.connectionRequestTimeoutMs$set) {
                    connectionRequestTimeoutMs$value = Configuration.$default$connectionRequestTimeoutMs();
                }
                String keystoreType$value = this.keystoreType$value;
                if (!this.keystoreType$set) {
                    keystoreType$value = Configuration.$default$keystoreType();
                }
                String keystorePath$value = this.keystorePath$value;
                if (!this.keystorePath$set) {
                    keystorePath$value = Configuration.$default$keystorePath();
                }
                String keystorePassword$value = this.keystorePassword$value;
                if (!this.keystorePassword$set) {
                    keystorePassword$value = Configuration.$default$keystorePassword();
                }
                String truststorePath$value = this.truststorePath$value;
                if (!this.truststorePath$set) {
                    truststorePath$value = Configuration.$default$truststorePath();
                }
                String truststorePassword$value = this.truststorePassword$value;
                if (!this.truststorePassword$set) {
                    truststorePassword$value = Configuration.$default$truststorePassword();
                }
                return new Configuration(scheme$value, hostnames$value, connectTimeoutMs$value, socketTimeoutMs$value, connectionRequestTimeoutMs$value, keystoreType$value, keystorePath$value, keystorePassword$value, truststorePath$value, truststorePassword$value);
            }

            @Generated
            public String toString() {
                return "ElasticsearchClients.Configuration.ConfigurationBuilder(scheme$value=" + this.scheme$value + ", hostnames$value=" + this.hostnames$value + ", connectTimeoutMs$value=" + this.connectTimeoutMs$value + ", socketTimeoutMs$value=" + this.socketTimeoutMs$value + ", connectionRequestTimeoutMs$value=" + this.connectionRequestTimeoutMs$value + ", keystoreType$value=" + this.keystoreType$value + ", keystorePath$value=" + this.keystorePath$value + ", keystorePassword$value=" + this.keystorePassword$value + ", truststorePath$value=" + this.truststorePath$value + ", truststorePassword$value=" + this.truststorePassword$value + ")";
            }
        }
    }
}

