/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.elasticsearch;

import com.google.auto.service.AutoService;
import com.google.common.collect.Sets;
import cz.o2.proxima.direct.core.DataAccessorFactory;
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.direct.elasticsearch.ElasticsearchAccessor;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import cz.o2.proxima.storage.internal.AbstractDataAccessorFactory;
import java.net.URI;

@AutoService(value={DataAccessorFactory.class})
public class ElasticsearchStorage
implements DataAccessorFactory {
    private static final long serialVersionUID = 1L;

    public ElasticsearchAccessor createAccessor(DirectDataOperator op, AttributeFamilyDescriptor family) {
        return new ElasticsearchAccessor(family.getEntity(), family.getStorageUri(), family.getCfg());
    }

    public AbstractDataAccessorFactory.Accept accepts(URI uri) {
        return Sets.newHashSet("elastic", "elasticsearch").contains(uri.getScheme()) ? AbstractDataAccessorFactory.Accept.ACCEPT : AbstractDataAccessorFactory.Accept.REJECT;
    }
}

