/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.elasticsearch.shaded.org.apache.http.message;

import cz.o2.proxima.elasticsearch.shaded.org.apache.http.HttpRequest;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.HttpVersion;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.ProtocolVersion;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.RequestLine;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.message.AbstractHttpMessage;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.message.BasicRequestLine;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.util.Args;

public class BasicHttpRequest
extends AbstractHttpMessage
implements HttpRequest {
    private final String method;
    private final String uri;
    private RequestLine requestline;

    public BasicHttpRequest(String method, String uri) {
        this.method = Args.notNull(method, "Method name");
        this.uri = Args.notNull(uri, "Request URI");
        this.requestline = null;
    }

    public BasicHttpRequest(String method, String uri, ProtocolVersion ver) {
        this(new BasicRequestLine(method, uri, ver));
    }

    public BasicHttpRequest(RequestLine requestline) {
        this.requestline = Args.notNull(requestline, "Request line");
        this.method = requestline.getMethod();
        this.uri = requestline.getUri();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    @Override
    public RequestLine getRequestLine() {
        if (this.requestline == null) {
            this.requestline = new BasicRequestLine(this.method, this.uri, HttpVersion.HTTP_1_1);
        }
        return this.requestline;
    }

    public String toString() {
        return this.method + ' ' + this.uri + ' ' + this.headergroup;
    }
}

