/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.elasticsearch.shaded.org.joda.time.convert;

import cz.o2.proxima.elasticsearch.shaded.org.joda.time.Chronology;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.DateTimeZone;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.chrono.BuddhistChronology;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.chrono.GJChronology;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.chrono.GregorianChronology;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.chrono.ISOChronology;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.chrono.JulianChronology;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.convert.AbstractConverter;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.convert.InstantConverter;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.convert.PartialConverter;
import java.util.Calendar;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CalendarConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final CalendarConverter INSTANCE = new CalendarConverter();

    protected CalendarConverter() {
    }

    @Override
    public Chronology getChronology(Object object, Chronology chronology) {
        if (chronology != null) {
            return chronology;
        }
        Calendar calendar = (Calendar)object;
        DateTimeZone dateTimeZone = null;
        try {
            dateTimeZone = DateTimeZone.forTimeZone(calendar.getTimeZone());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        return this.getChronology((Object)calendar, dateTimeZone);
    }

    @Override
    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        if (object.getClass().getName().endsWith(".BuddhistCalendar")) {
            return BuddhistChronology.getInstance(dateTimeZone);
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            long l = gregorianCalendar.getGregorianChange().getTime();
            if (l == Long.MIN_VALUE) {
                return GregorianChronology.getInstance(dateTimeZone);
            }
            if (l == Long.MAX_VALUE) {
                return JulianChronology.getInstance(dateTimeZone);
            }
            return GJChronology.getInstance(dateTimeZone, l, 4);
        }
        return ISOChronology.getInstance(dateTimeZone);
    }

    @Override
    public long getInstantMillis(Object object, Chronology chronology) {
        Calendar calendar = (Calendar)object;
        return calendar.getTime().getTime();
    }

    @Override
    public Class<?> getSupportedType() {
        return Calendar.class;
    }
}

