/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.get;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;

public class GetSettingsResponse
extends ActionResponse
implements ToXContentObject {
    private final ImmutableOpenMap<String, Settings> indexToSettings;
    private final ImmutableOpenMap<String, Settings> indexToDefaultSettings;

    public GetSettingsResponse(ImmutableOpenMap<String, Settings> indexToSettings, ImmutableOpenMap<String, Settings> indexToDefaultSettings) {
        this.indexToSettings = indexToSettings;
        this.indexToDefaultSettings = indexToDefaultSettings;
    }

    public GetSettingsResponse(StreamInput in) throws IOException {
        super(in);
        this.indexToSettings = in.readImmutableMap(StreamInput::readString, Settings::readSettingsFromStream);
        this.indexToDefaultSettings = in.readImmutableMap(StreamInput::readString, Settings::readSettingsFromStream);
    }

    public ImmutableOpenMap<String, Settings> getIndexToSettings() {
        return this.indexToSettings;
    }

    public ImmutableOpenMap<String, Settings> getIndexToDefaultSettings() {
        return this.indexToDefaultSettings;
    }

    public String getSetting(String index, String setting) {
        Settings settings = this.indexToSettings.get(index);
        if (setting != null) {
            if (settings != null && settings.hasValue(setting)) {
                return settings.get(setting);
            }
            Settings defaultSettings = this.indexToDefaultSettings.get(index);
            if (defaultSettings != null) {
                return defaultSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.indexToSettings, StreamOutput::writeString, (o, s2) -> Settings.writeSettingsToStream(s2, o));
        out.writeMap(this.indexToDefaultSettings, StreamOutput::writeString, (o, s2) -> Settings.writeSettingsToStream(s2, o));
    }

    private static void parseSettingsField(XContentParser parser, String currentIndexName, Map<String, Settings> indexToSettings, Map<String, Settings> indexToDefaultSettings) throws IOException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            switch (parser.currentName()) {
                case "settings": {
                    indexToSettings.put(currentIndexName, Settings.fromXContent(parser));
                    break;
                }
                case "defaults": {
                    indexToDefaultSettings.put(currentIndexName, Settings.fromXContent(parser));
                    break;
                }
                default: {
                    parser.skipChildren();
                    break;
                }
            }
        } else if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            parser.skipChildren();
        }
        parser.nextToken();
    }

    private static void parseIndexEntry(XContentParser parser, Map<String, Settings> indexToSettings, Map<String, Settings> indexToDefaultSettings) throws IOException {
        String indexName = parser.currentName();
        parser.nextToken();
        while (!parser.isClosed() && parser.currentToken() != XContentParser.Token.END_OBJECT) {
            GetSettingsResponse.parseSettingsField(parser, indexName, indexToSettings, indexToDefaultSettings);
        }
    }

    public static GetSettingsResponse fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Settings> indexToSettings = new HashMap<String, Settings>();
        HashMap<String, Settings> indexToDefaultSettings = new HashMap<String, Settings>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                GetSettingsResponse.parseIndexEntry(parser, indexToSettings, indexToDefaultSettings);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
        }
        ImmutableOpenMap<String, Settings> settingsMap = ImmutableOpenMap.builder().putAll(indexToSettings).build();
        ImmutableOpenMap<String, Settings> defaultSettingsMap = ImmutableOpenMap.builder().putAll(indexToDefaultSettings).build();
        return new GetSettingsResponse(settingsMap, defaultSettingsMap);
    }

    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XContentBuilder builder = new XContentBuilder(JsonXContent.jsonXContent, baos);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS, false);
            return Strings.toString(builder);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, this.indexToDefaultSettings.isEmpty());
    }

    private XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean omitEmptySettings) throws IOException {
        builder.startObject();
        for (ObjectObjectCursor<String, Settings> objectObjectCursor : this.getIndexToSettings()) {
            if (omitEmptySettings && ((Settings)objectObjectCursor.value).isEmpty()) continue;
            builder.startObject((String)objectObjectCursor.key);
            builder.startObject("settings");
            ((Settings)objectObjectCursor.value).toXContent(builder, params);
            builder.endObject();
            if (!this.indexToDefaultSettings.isEmpty()) {
                builder.startObject("defaults");
                this.indexToDefaultSettings.get((String)objectObjectCursor.key).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSettingsResponse that = (GetSettingsResponse)o;
        return Objects.equals(this.indexToSettings, that.indexToSettings) && Objects.equals(this.indexToDefaultSettings, that.indexToDefaultSettings);
    }

    public int hashCode() {
        return Objects.hash(this.indexToSettings, this.indexToDefaultSettings);
    }
}

