/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.enrich.DeletePolicyRequest;
import org.elasticsearch.client.enrich.ExecutePolicyRequest;
import org.elasticsearch.client.enrich.GetPolicyRequest;
import org.elasticsearch.client.enrich.PutPolicyRequest;
import org.elasticsearch.client.enrich.StatsRequest;

final class EnrichRequestConverters {
    EnrichRequestConverters() {
    }

    static Request putPolicy(PutPolicyRequest putPolicyRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_enrich", "policy").addPathPart(putPolicyRequest.getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putPolicyRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_enrich", "policy").addPathPart(deletePolicyRequest.getName()).build();
        return new Request("DELETE", endpoint);
    }

    static Request getPolicy(GetPolicyRequest getPolicyRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_enrich", "policy").addCommaSeparatedPathParts(getPolicyRequest.getNames()).build();
        return new Request("GET", endpoint);
    }

    static Request stats(StatsRequest statsRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_enrich", "_stats").build();
        return new Request("GET", endpoint);
    }

    static Request executePolicy(ExecutePolicyRequest executePolicyRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_enrich", "policy").addPathPart(executePolicyRequest.getName()).addPathPartAsIs("_execute").build();
        Request request = new Request("POST", endpoint);
        if (executePolicyRequest.getWaitForCompletion() != null) {
            request.addParameter("wait_for_completion", executePolicyRequest.getWaitForCompletion().toString());
        }
        return request;
    }
}

