/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

class LanguageRuntimeVersions {
    LanguageRuntimeVersions() {
    }

    public static String getRuntimeMetadata() {
        StringBuilder s2 = new StringBuilder();
        String version = LanguageRuntimeVersions.kotlinVersion();
        if (version != null) {
            s2.append(",kt=").append(version);
        }
        if ((version = LanguageRuntimeVersions.scalaVersion()) != null) {
            s2.append(",sc=").append(version);
        }
        if ((version = LanguageRuntimeVersions.clojureVersion()) != null) {
            s2.append(",clj=").append(version);
        }
        if ((version = LanguageRuntimeVersions.groovyVersion()) != null) {
            s2.append(",gy=").append(version);
        }
        if ((version = LanguageRuntimeVersions.jRubyVersion()) != null) {
            s2.append(",jrb=").append(version);
        }
        return s2.toString();
    }

    public static String kotlinVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.getStaticField("kotlin.KotlinVersion", "CURRENT"));
    }

    public static String scalaVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.callStaticMethod("scala.util.Properties", "versionNumberString"));
    }

    public static String clojureVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.callStaticMethod("clojure.core$clojure_version", "invokeStatic"));
    }

    public static String groovyVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.callStaticMethod("groovy.lang.GroovySystem", "getVersion"));
    }

    public static String jRubyVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.getStaticField("org.jruby.runtime.Constants", "VERSION"));
    }

    private static String getStaticField(String className, String fieldName) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            Field field = clazz.getField(fieldName);
            return field.get(null).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String callStaticMethod(String className, String methodName) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            Method m3 = clazz.getMethod(methodName, new Class[0]);
            return m3.invoke(null, new Object[0]).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    static String keepMajorMinor(String version) {
        if (version == null) {
            return null;
        }
        int firstDot = version.indexOf(46);
        int secondDot = version.indexOf(46, firstDot + 1);
        if (secondDot < 0) {
            return version;
        }
        return version.substring(0, secondDot);
    }
}

