/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import cz.o2.proxima.elasticsearch.shaded.org.apache.http.HttpEntity;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.entity.BufferedHttpEntity;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.client.Response;

public final class ResponseException
extends IOException {
    private final Response response;

    public ResponseException(Response response) throws IOException {
        super(ResponseException.buildMessage(response));
        this.response = response;
    }

    static String buildMessage(Response response) throws IOException {
        HttpEntity entity;
        String message = String.format(Locale.ROOT, "method [%s], host [%s], URI [%s], status line [%s]", response.getRequestLine().getMethod(), response.getHost(), response.getRequestLine().getUri(), response.getStatusLine().toString());
        if (response.hasWarnings()) {
            message = message + "\nWarnings: " + response.getWarnings();
        }
        if ((entity = response.getEntity()) != null) {
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(entity);
                response.getHttpResponse().setEntity(entity);
            }
            message = message + "\n" + EntityUtils.toString(entity);
        }
        return message;
    }

    public Response getResponse() {
        return this.response;
    }
}

