/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import cz.o2.proxima.elasticsearch.shaded.org.apache.http.Header;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.client.config.RequestConfig;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import cz.o2.proxima.elasticsearch.shaded.org.apache.http.util.VersionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.elasticsearch.client.LanguageRuntimeVersions;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.PersistentCredentialsAuthenticationStrategy;
import org.elasticsearch.client.RestClient;

public final class RestClientBuilder {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 1000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_MAX_CONN_PER_ROUTE = 10;
    public static final int DEFAULT_MAX_CONN_TOTAL = 30;
    public static final String VERSION;
    static final String META_HEADER_NAME = "X-Elastic-Client-Meta";
    static final String META_HEADER_VALUE;
    private static final String USER_AGENT_HEADER_VALUE;
    private static final Header[] EMPTY_HEADERS;
    private final List<Node> nodes;
    private Header[] defaultHeaders = EMPTY_HEADERS;
    private RestClient.FailureListener failureListener;
    private HttpClientConfigCallback httpClientConfigCallback;
    private RequestConfigCallback requestConfigCallback;
    private String pathPrefix;
    private NodeSelector nodeSelector = NodeSelector.ANY;
    private boolean strictDeprecationMode = false;
    private boolean compressionEnabled = false;
    private boolean metaHeaderEnabled = true;

    RestClientBuilder(List<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        for (Node node : nodes) {
            if (node != null) continue;
            throw new IllegalArgumentException("node cannot be null");
        }
        this.nodes = nodes;
    }

    public RestClientBuilder setDefaultHeaders(Header[] defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders must not be null");
        for (Header defaultHeader : defaultHeaders) {
            Objects.requireNonNull(defaultHeader, "default header must not be null");
        }
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public RestClientBuilder setFailureListener(RestClient.FailureListener failureListener) {
        Objects.requireNonNull(failureListener, "failureListener must not be null");
        this.failureListener = failureListener;
        return this;
    }

    public RestClientBuilder setHttpClientConfigCallback(HttpClientConfigCallback httpClientConfigCallback) {
        Objects.requireNonNull(httpClientConfigCallback, "httpClientConfigCallback must not be null");
        this.httpClientConfigCallback = httpClientConfigCallback;
        return this;
    }

    public RestClientBuilder setRequestConfigCallback(RequestConfigCallback requestConfigCallback) {
        Objects.requireNonNull(requestConfigCallback, "requestConfigCallback must not be null");
        this.requestConfigCallback = requestConfigCallback;
        return this;
    }

    public RestClientBuilder setPathPrefix(String pathPrefix) {
        this.pathPrefix = RestClientBuilder.cleanPathPrefix(pathPrefix);
        return this;
    }

    public static String cleanPathPrefix(String pathPrefix) {
        Objects.requireNonNull(pathPrefix, "pathPrefix must not be null");
        if (pathPrefix.isEmpty()) {
            throw new IllegalArgumentException("pathPrefix must not be empty");
        }
        String cleanPathPrefix = pathPrefix;
        if (!cleanPathPrefix.startsWith("/")) {
            cleanPathPrefix = "/" + cleanPathPrefix;
        }
        if (cleanPathPrefix.endsWith("/") && cleanPathPrefix.length() > 1 && (cleanPathPrefix = cleanPathPrefix.substring(0, cleanPathPrefix.length() - 1)).endsWith("/")) {
            throw new IllegalArgumentException("pathPrefix is malformed. too many trailing slashes: [" + pathPrefix + "]");
        }
        return cleanPathPrefix;
    }

    public RestClientBuilder setNodeSelector(NodeSelector nodeSelector) {
        Objects.requireNonNull(nodeSelector, "nodeSelector must not be null");
        this.nodeSelector = nodeSelector;
        return this;
    }

    public RestClientBuilder setStrictDeprecationMode(boolean strictDeprecationMode) {
        this.strictDeprecationMode = strictDeprecationMode;
        return this;
    }

    public RestClientBuilder setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
        return this;
    }

    public RestClientBuilder setMetaHeaderEnabled(boolean metadataEnabled) {
        this.metaHeaderEnabled = metadataEnabled;
        return this;
    }

    public RestClient build() {
        if (this.failureListener == null) {
            this.failureListener = new RestClient.FailureListener();
        }
        CloseableHttpAsyncClient httpClient = AccessController.doPrivileged(this::createHttpClient);
        RestClient restClient = new RestClient(httpClient, this.defaultHeaders, this.nodes, this.pathPrefix, this.failureListener, this.nodeSelector, this.strictDeprecationMode, this.compressionEnabled, this.metaHeaderEnabled);
        httpClient.start();
        return restClient;
    }

    private CloseableHttpAsyncClient createHttpClient() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(1000).setSocketTimeout(30000);
        if (this.requestConfigCallback != null) {
            requestConfigBuilder = this.requestConfigCallback.customizeRequestConfig(requestConfigBuilder);
        }
        try {
            HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build()).setMaxConnPerRoute(10).setMaxConnTotal(30).setSSLContext(SSLContext.getDefault()).setUserAgent(USER_AGENT_HEADER_VALUE).setTargetAuthenticationStrategy(new PersistentCredentialsAuthenticationStrategy());
            if (this.httpClientConfigCallback != null) {
                httpClientBuilder = this.httpClientConfigCallback.customizeHttpClient(httpClientBuilder);
            }
            HttpAsyncClientBuilder finalBuilder = httpClientBuilder;
            return AccessController.doPrivileged(finalBuilder::build);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("could not create the default ssl context", e);
        }
    }

    static {
        EMPTY_HEADERS = new Header[0];
        String version = null;
        try (InputStream is2 = RestClient.class.getResourceAsStream("version.properties");){
            if (is2 != null) {
                Properties versions = new Properties();
                versions.load(is2);
                version = versions.getProperty("elasticsearch-client");
            }
        }
        catch (IOException is2) {
            // empty catch block
        }
        if (version == null) {
            version = "";
        }
        VERSION = version;
        USER_AGENT_HEADER_VALUE = String.format(Locale.ROOT, "elasticsearch-java/%s (Java/%s)", VERSION.isEmpty() ? "Unknown" : VERSION, System.getProperty("java.version"));
        VersionInfo httpClientVersion = null;
        try {
            httpClientVersion = AccessController.doPrivileged(() -> VersionInfo.loadVersionInfo("cz.o2.proxima.elasticsearch.shaded.org.apache.http.nio.client", HttpAsyncClientBuilder.class.getClassLoader()));
        }
        catch (Exception versions) {
            // empty catch block
        }
        String metaVersion = version;
        int dashPos = metaVersion.indexOf(45);
        if (dashPos > 0) {
            metaVersion = metaVersion.substring(0, dashPos) + "p";
        }
        META_HEADER_VALUE = "es=" + metaVersion + ",jv=" + System.getProperty("java.specification.version") + ",t=" + metaVersion + ",hc=" + (httpClientVersion == null ? "" : httpClientVersion.getRelease()) + LanguageRuntimeVersions.getRuntimeMetadata();
    }

    public static interface HttpClientConfigCallback {
        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder var1);
    }

    public static interface RequestConfigCallback {
        public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder var1);
    }
}

