/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.client.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class EvaluateDataFrameResponse
implements ToXContentObject {
    private final String evaluationName;
    private final Map<String, EvaluationMetric.Result> metrics;

    public static EvaluateDataFrameResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
        String evaluationName = parser.currentName();
        parser.nextToken();
        Map<String, EvaluationMetric.Result> metrics = parser.map(LinkedHashMap::new, p -> EvaluateDataFrameResponse.parseMetric(evaluationName, p));
        List<EvaluationMetric.Result> knownMetrics = metrics.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        return new EvaluateDataFrameResponse(evaluationName, knownMetrics);
    }

    private static EvaluationMetric.Result parseMetric(String evaluationName, XContentParser parser) throws IOException {
        String metricName = parser.currentName();
        try {
            return parser.namedObject(EvaluationMetric.Result.class, MlEvaluationNamedXContentProvider.registeredMetricName(evaluationName, metricName), null);
        }
        catch (NamedObjectNotFoundException e) {
            parser.skipChildren();
            return null;
        }
    }

    public EvaluateDataFrameResponse(String evaluationName, List<EvaluationMetric.Result> metrics) {
        this.evaluationName = Objects.requireNonNull(evaluationName);
        this.metrics = Collections.unmodifiableMap(Objects.requireNonNull(metrics).stream().collect(Collectors.toMap(m3 -> m3.getMetricName(), m3 -> m3)));
    }

    public String getEvaluationName() {
        return this.evaluationName;
    }

    public List<EvaluationMetric.Result> getMetrics() {
        return this.metrics.values().stream().collect(Collectors.toList());
    }

    public <T extends EvaluationMetric.Result> T getMetricByName(String metricName) {
        Objects.requireNonNull(metricName);
        return (T)this.metrics.get(metricName);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(this.evaluationName, this.metrics).endObject();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluateDataFrameResponse that = (EvaluateDataFrameResponse)o;
        return Objects.equals(this.evaluationName, that.evaluationName) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.evaluationName, this.metrics);
    }

    public final String toString() {
        return Strings.toString(this);
    }
}

