/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.results;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.client.ml.job.results.Result;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class BucketInfluencer
implements ToXContentObject {
    public static final String RESULT_TYPE_VALUE = "bucket_influencer";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("bucket_influencer", new String[0]);
    public static final ParseField INFLUENCER_FIELD_NAME = new ParseField("influencer_field_name", new String[0]);
    public static final ParseField INITIAL_ANOMALY_SCORE = new ParseField("initial_anomaly_score", new String[0]);
    public static final ParseField ANOMALY_SCORE = new ParseField("anomaly_score", new String[0]);
    public static final ParseField RAW_ANOMALY_SCORE = new ParseField("raw_anomaly_score", new String[0]);
    public static final ParseField PROBABILITY = new ParseField("probability", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ConstructingObjectParser<BucketInfluencer, Void> PARSER = new ConstructingObjectParser(RESULT_TYPE_FIELD.getPreferredName(), true, a -> new BucketInfluencer((String)a[0], (Date)a[1], (Long)a[2]));
    private final String jobId;
    private String influenceField;
    private double initialAnomalyScore;
    private double anomalyScore;
    private double rawAnomalyScore;
    private double probability;
    private boolean isInterim;
    private final Date timestamp;
    private final long bucketSpan;

    BucketInfluencer(String jobId, Date timestamp, long bucketSpan) {
        this.jobId = jobId;
        this.timestamp = Objects.requireNonNull(timestamp);
        this.bucketSpan = bucketSpan;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        if (this.influenceField != null) {
            builder.field(INFLUENCER_FIELD_NAME.getPreferredName(), this.influenceField);
        }
        builder.field(INITIAL_ANOMALY_SCORE.getPreferredName(), this.initialAnomalyScore);
        builder.field(ANOMALY_SCORE.getPreferredName(), this.anomalyScore);
        builder.field(RAW_ANOMALY_SCORE.getPreferredName(), this.rawAnomalyScore);
        builder.field(PROBABILITY.getPreferredName(), this.probability);
        builder.timeField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public double getProbability() {
        return this.probability;
    }

    void setProbability(double probability) {
        this.probability = probability;
    }

    public String getInfluencerFieldName() {
        return this.influenceField;
    }

    void setInfluencerFieldName(String fieldName) {
        this.influenceField = fieldName;
    }

    public double getInitialAnomalyScore() {
        return this.initialAnomalyScore;
    }

    void setInitialAnomalyScore(double influenceScore) {
        this.initialAnomalyScore = influenceScore;
    }

    public double getAnomalyScore() {
        return this.anomalyScore;
    }

    void setAnomalyScore(double score) {
        this.anomalyScore = score;
    }

    public double getRawAnomalyScore() {
        return this.rawAnomalyScore;
    }

    void setRawAnomalyScore(double score) {
        this.rawAnomalyScore = score;
    }

    void setIsInterim(boolean isInterim) {
        this.isInterim = isInterim;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.influenceField, this.initialAnomalyScore, this.anomalyScore, this.rawAnomalyScore, this.probability, this.isInterim, this.timestamp, this.jobId, this.bucketSpan);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BucketInfluencer other = (BucketInfluencer)obj;
        return Objects.equals(this.influenceField, other.influenceField) && Double.compare(this.initialAnomalyScore, other.initialAnomalyScore) == 0 && Double.compare(this.anomalyScore, other.anomalyScore) == 0 && Double.compare(this.rawAnomalyScore, other.rawAnomalyScore) == 0 && Double.compare(this.probability, other.probability) == 0 && Objects.equals(this.isInterim, other.isInterim) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.jobId, other.jobId) && this.bucketSpan == other.bucketSpan;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeField(p, Result.TIMESTAMP.getPreferredName()), Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        PARSER.declareString((bucketInfluencer, s2) -> {}, Result.RESULT_TYPE);
        PARSER.declareString(BucketInfluencer::setInfluencerFieldName, INFLUENCER_FIELD_NAME);
        PARSER.declareDouble(BucketInfluencer::setInitialAnomalyScore, INITIAL_ANOMALY_SCORE);
        PARSER.declareDouble(BucketInfluencer::setAnomalyScore, ANOMALY_SCORE);
        PARSER.declareDouble(BucketInfluencer::setRawAnomalyScore, RAW_ANOMALY_SCORE);
        PARSER.declareDouble(BucketInfluencer::setProbability, PROBABILITY);
        PARSER.declareBoolean(BucketInfluencer::setIsInterim, Result.IS_INTERIM);
    }
}

