/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.tasks;

import java.util.Objects;

public class TaskId {
    protected final String nodeId;
    protected final long id;

    public TaskId(String nodeId, long id) {
        this.nodeId = nodeId;
        this.id = id;
    }

    public TaskId(String taskId) {
        if (taskId == null) {
            throw new IllegalArgumentException("null task id");
        }
        String[] s2 = taskId.split(":");
        if (s2.length != 2) {
            throw new IllegalArgumentException("malformed task id " + taskId);
        }
        this.nodeId = s2[0];
        try {
            this.id = Long.parseLong(s2[1]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("malformed task id " + taskId, ex);
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getId() {
        return this.id;
    }

    public boolean isSet() {
        return this.id != -1L;
    }

    public String toString() {
        if (this.isSet()) {
            return this.nodeId + ":" + this.id;
        }
        return "unset";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskId)) {
            return false;
        }
        TaskId taskId = (TaskId)o;
        return this.getId() == taskId.getId() && Objects.equals(this.getNodeId(), taskId.getNodeId());
    }

    public int hashCode() {
        return Objects.hash(this.getNodeId(), this.getId());
    }
}

