/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.TransformConfig;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class GetTransformResponse {
    public static final ParseField TRANSFORMS = new ParseField("transforms", new String[0]);
    public static final ParseField INVALID_TRANSFORMS = new ParseField("invalid_transforms", new String[0]);
    public static final ParseField COUNT = new ParseField("count", new String[0]);
    static final ConstructingObjectParser<InvalidTransforms, Void> INVALID_TRANSFORMS_PARSER = new ConstructingObjectParser("invalid_transforms", true, args -> new InvalidTransforms((List)args[0]));
    static final ConstructingObjectParser<GetTransformResponse, Void> PARSER = new ConstructingObjectParser("get_transform", true, args -> new GetTransformResponse((List)args[0], (Long)args[1], (InvalidTransforms)args[2]));
    private List<TransformConfig> transformConfigurations;
    private long count;
    private InvalidTransforms invalidTransforms;

    public static GetTransformResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public GetTransformResponse(List<TransformConfig> transformConfigurations, long count, @Nullable InvalidTransforms invalidTransforms) {
        this.transformConfigurations = transformConfigurations;
        this.count = count;
        this.invalidTransforms = invalidTransforms;
    }

    @Nullable
    public InvalidTransforms getInvalidTransforms() {
        return this.invalidTransforms;
    }

    public long getCount() {
        return this.count;
    }

    public List<TransformConfig> getTransformConfigurations() {
        return this.transformConfigurations;
    }

    public int hashCode() {
        return Objects.hash(this.transformConfigurations, this.count, this.invalidTransforms);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetTransformResponse that = (GetTransformResponse)other;
        return Objects.equals(this.transformConfigurations, that.transformConfigurations) && Objects.equals(this.count, that.count) && Objects.equals(this.invalidTransforms, that.invalidTransforms);
    }

    static {
        INVALID_TRANSFORMS_PARSER.declareLong((a, b) -> {}, COUNT);
        INVALID_TRANSFORMS_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), TRANSFORMS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), TransformConfig.PARSER::apply, TRANSFORMS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), COUNT);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), INVALID_TRANSFORMS_PARSER::apply, INVALID_TRANSFORMS);
    }

    static class InvalidTransforms {
        private final List<String> transformIds;

        InvalidTransforms(List<String> transformIds) {
            this.transformIds = transformIds;
        }

        public long getCount() {
            return this.transformIds.size();
        }

        public List<String> getTransformIds() {
            return this.transformIds;
        }

        public int hashCode() {
            return Objects.hash(this.transformIds);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            InvalidTransforms that = (InvalidTransforms)other;
            return Objects.equals(this.transformIds, that.transformIds);
        }
    }
}

