/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;

public interface ClusterStateTaskExecutor<T> {
    public ClusterTasksResult<T> execute(ClusterState var1, List<T> var2) throws Exception;

    default public boolean runOnlyOnMaster() {
        return true;
    }

    default public void clusterStatePublished(ClusterStatePublicationEvent clusterStatePublicationEvent) {
    }

    default public String describeTasks(List<T> tasks) {
        StringBuilder output = new StringBuilder();
        Strings.collectionToDelimitedStringWithLimit(() -> tasks.stream().map(Object::toString).filter(s2 -> !s2.isEmpty()).iterator(), ", ", "", "", 1024, output);
        return output.toString();
    }

    public static final class TaskResult {
        private final Exception failure;
        private static final TaskResult SUCCESS = new TaskResult(null);

        public static TaskResult success() {
            return SUCCESS;
        }

        public static TaskResult failure(Exception failure) {
            return new TaskResult(failure);
        }

        private TaskResult(Exception failure) {
            this.failure = failure;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public Exception getFailure() {
            assert (!this.isSuccess());
            return this.failure;
        }
    }

    public static class ClusterTasksResult<T> {
        @Nullable
        public final ClusterState resultingState;
        public final Map<T, TaskResult> executionResults;

        ClusterTasksResult(ClusterState resultingState, Map<T, TaskResult> executionResults) {
            this.resultingState = resultingState;
            this.executionResults = executionResults;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T> {
            private final Map<T, TaskResult> executionResults = new IdentityHashMap<T, TaskResult>();

            public Builder<T> success(T task) {
                return this.result(task, TaskResult.success());
            }

            public Builder<T> successes(Iterable<T> tasks) {
                for (T task : tasks) {
                    this.success(task);
                }
                return this;
            }

            public Builder<T> failure(T task, Exception e) {
                return this.result(task, TaskResult.failure(e));
            }

            public Builder<T> failures(Iterable<T> tasks, Exception e) {
                for (T task : tasks) {
                    this.failure(task, e);
                }
                return this;
            }

            private Builder<T> result(T task, TaskResult executionResult) {
                TaskResult existing = this.executionResults.put(task, executionResult);
                assert (existing == null) : task + " already has result " + existing;
                return this;
            }

            public ClusterTasksResult<T> build(ClusterState resultingState) {
                return new ClusterTasksResult<T>(resultingState, this.executionResults);
            }

            ClusterTasksResult<T> build(ClusterTasksResult<T> result, ClusterState previousState) {
                return new ClusterTasksResult<T>(result.resultingState == null ? previousState : result.resultingState, this.executionResults);
            }
        }
    }
}

