/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;

public interface IndexAbstraction {
    public Type getType();

    public String getName();

    public List<Index> getIndices();

    @Nullable
    public Index getWriteIndex();

    @Nullable
    public DataStream getParentDataStream();

    public boolean isHidden();

    public boolean isSystem();

    default public boolean isDataStreamRelated() {
        return false;
    }

    @Nullable
    public List<String> getAliases();

    public static class DataStream
    implements IndexAbstraction {
        private final org.elasticsearch.cluster.metadata.DataStream dataStream;
        private final List<String> referencedByDataStreamAliases;

        public DataStream(org.elasticsearch.cluster.metadata.DataStream dataStream, List<String> aliases) {
            this.dataStream = dataStream;
            this.referencedByDataStreamAliases = aliases;
        }

        @Override
        public String getName() {
            return this.dataStream.getName();
        }

        @Override
        public Type getType() {
            return Type.DATA_STREAM;
        }

        @Override
        public List<Index> getIndices() {
            return this.dataStream.getIndices();
        }

        @Override
        public Index getWriteIndex() {
            return this.dataStream.getWriteIndex();
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.dataStream.isHidden();
        }

        @Override
        public boolean isSystem() {
            return this.dataStream.isSystem();
        }

        @Override
        public boolean isDataStreamRelated() {
            return true;
        }

        @Override
        public List<String> getAliases() {
            return this.referencedByDataStreamAliases;
        }

        public org.elasticsearch.cluster.metadata.DataStream getDataStream() {
            return this.dataStream;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataStream that = (DataStream)o;
            return this.dataStream.equals(that.dataStream) && Objects.equals(this.referencedByDataStreamAliases, that.referencedByDataStreamAliases);
        }

        public int hashCode() {
            return Objects.hash(this.dataStream, this.referencedByDataStreamAliases);
        }
    }

    public static class Alias
    implements IndexAbstraction {
        private final String aliasName;
        private final List<Index> referenceIndexMetadatas;
        private final Index writeIndex;
        private final boolean isHidden;
        private final boolean isSystem;
        private final boolean dataStreamAlias;

        public Alias(AliasMetadata aliasMetadata, List<IndexMetadata> indices) {
            this.aliasName = aliasMetadata.getAlias();
            this.referenceIndexMetadatas = new ArrayList<Index>(indices.size());
            for (IndexMetadata imd : indices) {
                this.referenceIndexMetadatas.add(imd.getIndex());
            }
            List writeIndices = indices.stream().filter(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).writeIndex())).collect(Collectors.toList());
            if (writeIndices.isEmpty() && indices.size() == 1 && indices.get(0).getAliases().get(this.aliasName).writeIndex() == null) {
                writeIndices.add(indices.get(0));
            }
            if (writeIndices.size() == 0) {
                this.writeIndex = null;
            } else if (writeIndices.size() == 1) {
                this.writeIndex = ((IndexMetadata)writeIndices.get(0)).getIndex();
            } else {
                List writeIndicesStrings = writeIndices.stream().map(i -> i.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has more than one write index [" + Strings.collectionToCommaDelimitedString(writeIndicesStrings) + "]");
            }
            this.isHidden = aliasMetadata.isHidden() == null ? false : aliasMetadata.isHidden();
            this.isSystem = indices.stream().allMatch(IndexMetadata::isSystem);
            this.dataStreamAlias = false;
            this.validateAliasProperties(indices);
        }

        public Alias(DataStreamAlias dataStreamAlias, List<Index> indicesOfAllDataStreams, Index writeIndexOfWriteDataStream) {
            this.aliasName = dataStreamAlias.getName();
            this.referenceIndexMetadatas = indicesOfAllDataStreams;
            this.writeIndex = writeIndexOfWriteDataStream;
            this.isHidden = false;
            this.isSystem = false;
            this.dataStreamAlias = true;
        }

        @Override
        public Type getType() {
            return Type.ALIAS;
        }

        @Override
        public String getName() {
            return this.aliasName;
        }

        @Override
        public List<Index> getIndices() {
            return this.referenceIndexMetadatas;
        }

        @Override
        @Nullable
        public Index getWriteIndex() {
            return this.writeIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.isSystem;
        }

        @Override
        public boolean isDataStreamRelated() {
            return this.dataStreamAlias;
        }

        @Override
        public List<String> getAliases() {
            return null;
        }

        private void validateAliasProperties(List<IndexMetadata> referenceIndexMetadatas) {
            Map<Boolean, List<IndexMetadata>> groupedByHiddenStatus = referenceIndexMetadatas.stream().collect(Collectors.groupingBy(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).isHidden())));
            if (this.isNonEmpty(groupedByHiddenStatus.get(true)) && this.isNonEmpty(groupedByHiddenStatus.get(false))) {
                List hiddenOn = groupedByHiddenStatus.get(true).stream().map(idx -> idx.getIndex().getName()).collect(Collectors.toList());
                List nonHiddenOn = groupedByHiddenStatus.get(false).stream().map(idx -> idx.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(hiddenOn) + "] but does not have is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(nonHiddenOn) + "]; alias must have the same is_hidden setting on all indices");
            }
        }

        private boolean isNonEmpty(List<IndexMetadata> idxMetas) {
            return !(Objects.isNull(idxMetas) || idxMetas.isEmpty());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Alias alias = (Alias)o;
            return this.isHidden == alias.isHidden && this.isSystem == alias.isSystem && this.dataStreamAlias == alias.dataStreamAlias && this.aliasName.equals(alias.aliasName) && this.referenceIndexMetadatas.equals(alias.referenceIndexMetadatas) && Objects.equals(this.writeIndex, alias.writeIndex);
        }

        public int hashCode() {
            return Objects.hash(this.aliasName, this.referenceIndexMetadatas, this.writeIndex, this.isHidden, this.isSystem, this.dataStreamAlias);
        }
    }

    public static class ConcreteIndex
    implements IndexAbstraction {
        private final Index concreteIndexName;
        private final boolean isHidden;
        private final boolean isSystem;
        private final List<String> aliases;
        private final DataStream dataStream;

        public ConcreteIndex(IndexMetadata indexMetadata, DataStream dataStream) {
            this.concreteIndexName = indexMetadata.getIndex();
            this.isHidden = indexMetadata.isHidden();
            this.isSystem = indexMetadata.isSystem();
            this.aliases = indexMetadata.getAliases() != null ? Arrays.asList(indexMetadata.getAliases().keys().toArray(String.class)) : null;
            this.dataStream = dataStream;
        }

        public ConcreteIndex(IndexMetadata indexMetadata) {
            this(indexMetadata, null);
        }

        @Override
        public String getName() {
            return this.concreteIndexName.getName();
        }

        @Override
        public Type getType() {
            return Type.CONCRETE_INDEX;
        }

        @Override
        public List<Index> getIndices() {
            return Collections.singletonList(this.concreteIndexName);
        }

        @Override
        public Index getWriteIndex() {
            return this.concreteIndexName;
        }

        @Override
        public DataStream getParentDataStream() {
            return this.dataStream;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.isSystem;
        }

        @Override
        public List<String> getAliases() {
            return this.aliases;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcreteIndex that = (ConcreteIndex)o;
            return this.isHidden == that.isHidden && this.isSystem == that.isSystem && this.concreteIndexName.equals(that.concreteIndexName) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.dataStream, that.dataStream);
        }

        public int hashCode() {
            return Objects.hash(this.concreteIndexName, this.isHidden, this.isSystem, this.aliases, this.dataStream);
        }
    }

    public static enum Type {
        CONCRETE_INDEX("concrete index"),
        ALIAS("alias"),
        DATA_STREAM("data_stream");

        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

