/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hash;

import java.math.BigInteger;
import java.util.Objects;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.util.ByteUtils;

public final class MurmurHash3
extends Enum<MurmurHash3> {
    private static long C1;
    private static long C2;
    private static final /* synthetic */ MurmurHash3[] $VALUES;

    public static MurmurHash3[] values() {
        return (MurmurHash3[])$VALUES.clone();
    }

    public static MurmurHash3 valueOf(String name) {
        return Enum.valueOf(MurmurHash3.class, name);
    }

    protected static long getblock(byte[] key, int offset, int index) {
        int i_8 = index << 3;
        int blockOffset = offset + i_8;
        return ByteUtils.readLongLE(key, blockOffset);
    }

    protected static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static Hash128 hash128(byte[] key, int offset, int length, long seed, Hash128 hash) {
        long h1 = seed;
        long h2 = seed;
        if (length >= 16) {
            IntermediateResult result = MurmurHash3.intermediateHash(key, offset, length, h1, h2);
            h1 = result.h1;
            h2 = result.h2;
            offset = result.offset;
        }
        return MurmurHash3.finalizeHash(hash, key, offset, length, h1, h2);
    }

    static IntermediateResult intermediateHash(byte[] key, int offset, int length, long h1, long h2) {
        int len16 = length & 0xFFFFFFF0;
        int end = offset + len16;
        for (int i = offset; i < end; i += 16) {
            long k1 = ByteUtils.readLongLE(key, i);
            long k2 = ByteUtils.readLongLE(key, i + 8);
            k1 *= C1;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= C2);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= C2;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= C1);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        offset = end;
        return new IntermediateResult(offset, h1, h2);
    }

    static Hash128 finalizeHash(Hash128 hash, byte[] remainder, int offset, int length, long h1, long h2) {
        long k1 = 0L;
        long k2 = 0L;
        switch (length & 0xF) {
            case 15: {
                k2 ^= ((long)remainder[offset + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)remainder[offset + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)remainder[offset + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)remainder[offset + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)remainder[offset + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)remainder[offset + 9] & 0xFFL) << 8;
            }
            case 9: {
                k2 ^= ((long)remainder[offset + 8] & 0xFFL) << 0;
                k2 *= C2;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= C1);
            }
            case 8: {
                k1 ^= ((long)remainder[offset + 7] & 0xFFL) << 56;
            }
            case 7: {
                k1 ^= ((long)remainder[offset + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)remainder[offset + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)remainder[offset + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)remainder[offset + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)remainder[offset + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)remainder[offset + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= (long)remainder[offset] & 0xFFL;
                k1 *= C1;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= C2);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = MurmurHash3.fmix(h1);
        h2 = MurmurHash3.fmix(h2);
        h1 += h2;
        hash.h1 = h1;
        hash.h2 = h2 += h1;
        return hash;
    }

    public static long murmur64(long h2) {
        h2 ^= h2 >>> 33;
        h2 *= -49064778989728563L;
        h2 ^= h2 >>> 33;
        h2 *= -4265267296055464877L;
        h2 ^= h2 >>> 33;
        return h2;
    }

    private static /* synthetic */ MurmurHash3[] $values() {
        return new MurmurHash3[0];
    }

    static {
        $VALUES = MurmurHash3.$values();
        C1 = -8663945395140668459L;
        C2 = 5545529020109919103L;
    }

    static class IntermediateResult {
        int offset;
        long h1;
        long h2;

        IntermediateResult(int offset, long h1, long h2) {
            this.offset = offset;
            this.h1 = h1;
            this.h2 = h2;
        }
    }

    public static class Hash128 {
        public long h1;
        public long h2;

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Hash128 that = (Hash128)other;
            return Objects.equals(this.h1, that.h1) && Objects.equals(this.h2, that.h2);
        }

        public int hashCode() {
            return Objects.hash(this.h1, this.h2);
        }

        public String toString() {
            byte[] longBytes = new byte[17];
            System.arraycopy(Numbers.longToBytes(this.h1), 0, longBytes, 1, 8);
            System.arraycopy(Numbers.longToBytes(this.h2), 0, longBytes, 9, 8);
            BigInteger bi = new BigInteger(longBytes);
            return "0x" + bi.toString(16);
        }
    }
}

