/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import cz.o2.proxima.elasticsearch.shaded.org.joda.time.DateTime;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.DateTimeZone;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.format.DateTimeFormatter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.joda.JodaDateMathParser;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;

public class JodaDateFormatter
implements DateFormatter {
    final String pattern;
    final DateTimeFormatter parser;
    final DateTimeFormatter printer;

    JodaDateFormatter(String pattern, DateTimeFormatter parser, DateTimeFormatter printer) {
        this.pattern = pattern;
        this.printer = printer;
        this.parser = parser;
    }

    @Override
    public TemporalAccessor parse(String input) {
        DateTime dt = this.parser.parseDateTime(input);
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(dt.getMillis()), DateUtils.dateTimeZoneToZoneId(dt.getZone()));
    }

    @Override
    public long parseMillis(String input) {
        return this.parser.parseMillis(input);
    }

    @Override
    public DateTime parseJoda(String input) {
        return this.parser.parseDateTime(input);
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        DateTimeZone timeZone = DateUtils.zoneIdToDateTimeZone(zoneId);
        if (this.parser.getZone().equals(timeZone)) {
            return this;
        }
        DateTimeFormatter parser = this.parser.withZone(timeZone);
        DateTimeFormatter printer = this.printer.withZone(timeZone);
        return new JodaDateFormatter(this.pattern, parser, printer);
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (this.parser.getLocale().equals(locale)) {
            return this;
        }
        DateTimeFormatter parser = this.parser.withLocale(locale);
        DateTimeFormatter printer = this.printer.withLocale(locale);
        return new JodaDateFormatter(this.pattern, parser, printer);
    }

    @Override
    public String format(TemporalAccessor accessor) {
        DateTimeZone timeZone = DateUtils.zoneIdToDateTimeZone(ZoneId.from(accessor));
        DateTime dateTime = new DateTime(Instant.from(accessor).toEpochMilli(), timeZone);
        return this.printer.print(dateTime);
    }

    @Override
    public String formatJoda(DateTime dateTime) {
        return this.printer.print(dateTime);
    }

    @Override
    public String formatMillis(long millis) {
        return this.printer.print(millis);
    }

    public JodaDateFormatter withYear(int year) {
        if (this.parser.getDefaultYear() == year) {
            return this;
        }
        return new JodaDateFormatter(this.pattern, this.parser.withDefaultYear(year), this.printer.withDefaultYear(year));
    }

    @Override
    public String pattern() {
        return this.pattern;
    }

    @Override
    public Locale locale() {
        return this.printer.getLocale();
    }

    @Override
    public ZoneId zone() {
        return DateUtils.dateTimeZoneToZoneId(this.printer.getZone());
    }

    @Override
    public DateMathParser toDateMathParser() {
        return new JodaDateMathParser(this);
    }

    public int hashCode() {
        return Objects.hash(this.locale(), this.zone(), this.pattern());
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        JodaDateFormatter other = (JodaDateFormatter)obj;
        return Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.zone(), other.zone());
    }
}

