/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.rounding;

import cz.o2.proxima.elasticsearch.shaded.org.joda.time.DateTimeField;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.DateTimeZone;
import cz.o2.proxima.elasticsearch.shaded.org.joda.time.chrono.ISOChronology;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.joda.Joda;

public enum DateTimeUnit {
    WEEK_OF_WEEKYEAR(1, tz -> ISOChronology.getInstance(tz).weekOfWeekyear()),
    YEAR_OF_CENTURY(2, tz -> ISOChronology.getInstance(tz).yearOfCentury()),
    QUARTER(3, tz -> Joda.QuarterOfYear.getField(ISOChronology.getInstance(tz))),
    MONTH_OF_YEAR(4, tz -> ISOChronology.getInstance(tz).monthOfYear()),
    DAY_OF_MONTH(5, tz -> ISOChronology.getInstance(tz).dayOfMonth()),
    HOUR_OF_DAY(6, tz -> ISOChronology.getInstance(tz).hourOfDay()),
    MINUTES_OF_HOUR(7, tz -> ISOChronology.getInstance(tz).minuteOfHour()),
    SECOND_OF_MINUTE(8, tz -> ISOChronology.getInstance(tz).secondOfMinute());

    private final byte id;
    private final Function<DateTimeZone, DateTimeField> fieldFunction;

    private DateTimeUnit(byte id, Function<DateTimeZone, DateTimeField> fieldFunction) {
        this.id = id;
        this.fieldFunction = fieldFunction;
    }

    public byte id() {
        return this.id;
    }

    public DateTimeField field(DateTimeZone tz) {
        return this.fieldFunction.apply(tz);
    }

    public static DateTimeUnit resolve(byte id) {
        switch (id) {
            case 1: {
                return WEEK_OF_WEEKYEAR;
            }
            case 2: {
                return YEAR_OF_CENTURY;
            }
            case 3: {
                return QUARTER;
            }
            case 4: {
                return MONTH_OF_YEAR;
            }
            case 5: {
                return DAY_OF_MONTH;
            }
            case 6: {
                return HOUR_OF_DAY;
            }
            case 7: {
                return MINUTES_OF_HOUR;
            }
            case 8: {
                return SECOND_OF_MINUTE;
            }
        }
        throw new ElasticsearchException("Unknown date time unit id [" + id + "]", new Object[0]);
    }
}

