/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class LazyMap<K, V>
implements Map<K, V> {
    private final Supplier<Map<K, V>> mapSupplier;
    private volatile Map<K, V> map;

    public LazyMap(Supplier<Map<K, V>> mapSupplier) {
        this.mapSupplier = mapSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> get() {
        if (this.map == null) {
            LazyMap lazyMap = this;
            synchronized (lazyMap) {
                if (this.map == null) {
                    this.map = this.mapSupplier.get();
                }
                if (this.map == null) {
                    this.map = Collections.emptyMap();
                }
            }
        }
        return this.map;
    }

    @Override
    public int size() {
        return this.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.get().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.get().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.get().get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.get().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.get().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m3) {
        this.get().putAll(m3);
    }

    @Override
    public void clear() {
        this.get().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.get().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.get().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.get().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.get().equals(o);
    }

    @Override
    public int hashCode() {
        return this.get().hashCode();
    }

    public String toString() {
        return this.get().toString();
    }

    @Override
    public V getOrDefault(Object k, V defaultValue) {
        return this.get().getOrDefault(k, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.get().forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.get().replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.get().putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.get().remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.get().replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.get().replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.get().computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.get().computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.get().compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.get().merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }
}

