/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentParser;

public class ScaledFloatFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "scaled_float";
    private static final Setting<Boolean> COERCE_SETTING = NumberFieldMapper.COERCE_SETTING;
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getSettings()));
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> coerce;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Double nullValue;
    private final double scalingFactor;
    private final boolean ignoreMalformedByDefault;
    private final boolean coerceByDefault;
    private final TimeSeriesParams.MetricType metricType;

    private static ScaledFloatFieldMapper toType(FieldMapper in) {
        return (ScaledFloatFieldMapper)in;
    }

    private ScaledFloatFieldMapper(String simpleName, ScaledFloatFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.stored = (Boolean)builder.stored.getValue();
        this.scalingFactor = (Double)builder.scalingFactor.getValue();
        this.nullValue = (Double)builder.nullValue.getValue();
        this.ignoreMalformed = (Explicit)builder.ignoreMalformed.getValue();
        this.coerce = (Explicit)builder.coerce.getValue();
        this.ignoreMalformedByDefault = (Boolean)((Explicit)builder.ignoreMalformed.getDefaultValue()).value();
        this.coerceByDefault = (Boolean)((Explicit)builder.coerce.getDefaultValue()).value();
        this.metricType = (TimeSeriesParams.MetricType)((Object)builder.metric.getValue());
    }

    boolean coerce() {
        return this.coerce.value();
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    @Override
    public ScaledFloatFieldType fieldType() {
        return (ScaledFloatFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.ignoreMalformedByDefault, this.coerceByDefault).metric(this.metricType).init(this);
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        double doubleValue;
        Number value;
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (this.coerce.value().booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = ScaledFloatFieldMapper.parse(parser, this.coerce.value());
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue()) {
                    return;
                }
                throw e;
            }
            value = numericValue;
        }
        if (value == null) {
            value = this.nullValue;
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = ScaledFloatFieldMapper.parse(value);
        }
        if (!Double.isFinite(doubleValue = numericValue.doubleValue())) {
            if (this.ignoreMalformed.value().booleanValue()) {
                return;
            }
            throw new IllegalArgumentException("[scaled_float] only supports finite values, but got [" + doubleValue + "]");
        }
        long scaledValue = Math.round(doubleValue * this.scalingFactor);
        List<Field> fields = NumberFieldMapper.NumberType.LONG.createFields(this.fieldType().name(), scaledValue, this.indexed, this.hasDocValues, this.stored);
        context.doc().addAll(fields);
        if (!this.hasDocValues && (this.indexed || this.stored)) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    static Double parse(Object value) {
        return ScaledFloatFieldMapper.objectToDouble(value);
    }

    private static Double parse(XContentParser parser, boolean coerce) throws IOException {
        return parser.doubleValue(coerce);
    }

    private static double objectToDouble(Object value) {
        double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
        return doubleValue;
    }

    public static final class ScaledFloatFieldType
    extends SimpleMappedFieldType {
        private final double scalingFactor;
        private final Double nullValue;
        private final TimeSeriesParams.MetricType metricType;

        public ScaledFloatFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta, double scalingFactor, Double nullValue, TimeSeriesParams.MetricType metricType) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.scalingFactor = scalingFactor;
            this.nullValue = nullValue;
            this.metricType = metricType;
        }

        public ScaledFloatFieldType(String name, double scalingFactor) {
            this(name, true, false, true, Collections.emptyMap(), scalingFactor, null, null);
        }

        public double getScalingFactor() {
            return this.scalingFactor;
        }

        @Override
        public String typeName() {
            return ScaledFloatFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            this.failIfNotIndexed();
            long scaledValue = Math.round(this.scale(value));
            Query query = NumberFieldMapper.NumberType.LONG.termQuery(this.name(), scaledValue);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexed();
            ArrayList<Long> scaledValues = new ArrayList<Long>(values.size());
            for (Object value : values) {
                long scaledValue = Math.round(this.scale(value));
                scaledValues.add(scaledValue);
            }
            Query query = NumberFieldMapper.NumberType.LONG.termsQuery(this.name(), Collections.unmodifiableList(scaledValues));
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexed();
            Long lo = null;
            if (lowerTerm != null) {
                double dValue = this.scale(lowerTerm);
                if (!includeLower) {
                    dValue = Math.nextUp(dValue);
                }
                lo = Math.round(Math.ceil(dValue));
            }
            Long hi = null;
            if (upperTerm != null) {
                double dValue = this.scale(upperTerm);
                if (!includeUpper) {
                    dValue = Math.nextDown(dValue);
                }
                hi = Math.round(Math.floor(dValue));
            }
            Query query = NumberFieldMapper.NumberType.LONG.rangeQuery(this.name(), lo, hi, true, true, this.hasDocValues(), context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> {
                SortedNumericIndexFieldData scaledValues = new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG).build(cache, breakerService);
                return new ScaledFloatIndexFieldData(scaledValues, this.scalingFactor);
            };
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context){

                @Override
                protected Double parseSourceValue(Object value) {
                    double doubleValue;
                    if (value.equals("")) {
                        if (nullValue == null) {
                            return null;
                        }
                        doubleValue = nullValue;
                    } else {
                        doubleValue = ScaledFloatFieldMapper.objectToDouble(value);
                    }
                    double scalingFactor = this.getScalingFactor();
                    return (double)Math.round(doubleValue * scalingFactor) / scalingFactor;
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return (double)((Number)value).longValue() / this.scalingFactor;
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            this.checkNoTimeZone(timeZone);
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        private double scale(Object input) {
            return new BigDecimal(Double.toString(ScaledFloatFieldMapper.parse(input))).multiply(BigDecimal.valueOf(this.scalingFactor)).doubleValue();
        }

        public TimeSeriesParams.MetricType getMetricType() {
            return this.metricType;
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m3 -> ScaledFloatFieldMapper.access$1000(ScaledFloatFieldMapper.toType(m3)), true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m3 -> ScaledFloatFieldMapper.access$900(ScaledFloatFieldMapper.toType(m3)), true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m3 -> ScaledFloatFieldMapper.access$800(ScaledFloatFieldMapper.toType(m3)), false);
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final FieldMapper.Parameter<Double> scalingFactor = new FieldMapper.Parameter<Double>("scaling_factor", false, () -> null, (n, c, o) -> XContentMapValues.nodeDoubleValue(o), m3 -> ScaledFloatFieldMapper.access$700(ScaledFloatFieldMapper.toType(m3))).addValidator(v -> {
            if (v == null) {
                throw new IllegalArgumentException("Field [scaling_factor] is required");
            }
            if (!Double.isFinite(v) || v <= 0.0) {
                throw new IllegalArgumentException("[scaling_factor] must be a positive number, got [" + v + "]");
            }
        });
        private final FieldMapper.Parameter<Double> nullValue = new FieldMapper.Parameter<Double>("null_value", false, () -> null, (n, c, o) -> o == null ? null : Double.valueOf(XContentMapValues.nodeDoubleValue(o)), m3 -> ScaledFloatFieldMapper.access$600(ScaledFloatFieldMapper.toType(m3))).acceptsNull();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<TimeSeriesParams.MetricType> metric;

        public Builder(String name, Settings settings) {
            this(name, FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), (Boolean)COERCE_SETTING.get(settings));
        }

        public Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m3 -> ScaledFloatFieldMapper.toType(m3).ignoreMalformed, ignoreMalformedByDefault);
            this.coerce = FieldMapper.Parameter.explicitBoolParam("coerce", true, m3 -> ScaledFloatFieldMapper.toType(m3).coerce, coerceByDefault);
            this.metric = TimeSeriesParams.metricParam(m3 -> ScaledFloatFieldMapper.toType(m3).metricType, TimeSeriesParams.MetricType.gauge, TimeSeriesParams.MetricType.counter).addValidator(v -> {
                if (v != null && !this.hasDocValues.getValue().booleanValue()) {
                    throw new IllegalArgumentException("Field [time_series_metric] requires that [" + this.hasDocValues.name + "] is true");
                }
            });
        }

        Builder scalingFactor(double scalingFactor) {
            this.scalingFactor.setValue(scalingFactor);
            return this;
        }

        Builder nullValue(double nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder metric(TimeSeriesParams.MetricType metric) {
            this.metric.setValue(metric);
            return this;
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.meta, this.scalingFactor, this.coerce, this.nullValue, this.metric);
        }

        @Override
        public ScaledFloatFieldMapper build(MapperBuilderContext context) {
            ScaledFloatFieldType type = new ScaledFloatFieldType(context.buildFullName(this.name), this.indexed.getValue(), this.stored.getValue(), this.hasDocValues.getValue(), this.meta.getValue(), this.scalingFactor.getValue(), this.nullValue.getValue(), this.metric.getValue());
            return new ScaledFloatFieldMapper(this.name, type, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    private static class ScaledFloatLeafFieldData
    implements LeafNumericFieldData {
        private final LeafNumericFieldData scaledFieldData;
        private final double scalingFactorInverse;

        ScaledFloatLeafFieldData(LeafNumericFieldData scaledFieldData, double scalingFactor) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactorInverse = 1.0 / scalingFactor;
        }

        public ScriptDocValues.Doubles getScriptValues() {
            return new ScriptDocValues.Doubles(this.getDoubleValues());
        }

        @Override
        public SortedBinaryDocValues getBytesValues() {
            return FieldData.toString(this.getDoubleValues());
        }

        @Override
        public long ramBytesUsed() {
            return this.scaledFieldData.ramBytesUsed();
        }

        @Override
        public void close() {
            this.scaledFieldData.close();
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return FieldData.castToLong(this.getDoubleValues());
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            final SortedNumericDocValues values = this.scaledFieldData.getLongValues();
            final NumericDocValues singleValues = DocValues.unwrapSingleton(values);
            if (singleValues != null) {
                return FieldData.singleton(new NumericDoubleValues(){

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        return singleValues.advanceExact(doc);
                    }

                    @Override
                    public double doubleValue() throws IOException {
                        return (double)singleValues.longValue() * scalingFactorInverse;
                    }
                });
            }
            return new SortedNumericDoubleValues(){

                @Override
                public boolean advanceExact(int target) throws IOException {
                    return values.advanceExact(target);
                }

                @Override
                public double nextValue() throws IOException {
                    return (double)values.nextValue() * scalingFactorInverse;
                }

                @Override
                public int docValueCount() {
                    return values.docValueCount();
                }
            };
        }

        @Override
        public FormattedDocValues getFormattedValues(final DocValueFormat format) {
            final SortedNumericDoubleValues values = this.getDoubleValues();
            return new FormattedDocValues(){

                @Override
                public boolean advanceExact(int docId) throws IOException {
                    return values.advanceExact(docId);
                }

                @Override
                public int docValueCount() throws IOException {
                    return values.docValueCount();
                }

                @Override
                public Object nextValue() throws IOException {
                    return format.format(values.nextValue());
                }
            };
        }
    }

    private static class ScaledFloatIndexFieldData
    extends IndexNumericFieldData {
        private final IndexNumericFieldData scaledFieldData;
        private final double scalingFactor;

        ScaledFloatIndexFieldData(IndexNumericFieldData scaledFieldData, double scalingFactor) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactor = scalingFactor;
        }

        @Override
        public String getFieldName() {
            return this.scaledFieldData.getFieldName();
        }

        @Override
        public ValuesSourceType getValuesSourceType() {
            return this.scaledFieldData.getValuesSourceType();
        }

        @Override
        public LeafNumericFieldData load(LeafReaderContext context) {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.load(context), this.scalingFactor);
        }

        @Override
        public LeafNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.loadDirect(context), this.scalingFactor);
        }

        @Override
        protected boolean sortRequiresCustomComparator() {
            return true;
        }

        @Override
        public IndexNumericFieldData.NumericType getNumericType() {
            return IndexNumericFieldData.NumericType.DOUBLE;
        }
    }
}

