/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.similarity.SimilarityProvider;

public final class TextParams {
    private TextParams() {
    }

    public static FieldMapper.Parameter<Boolean> norms(boolean defaultValue, Function<FieldMapper, Boolean> initializer) {
        return FieldMapper.Parameter.boolParam("norms", true, initializer, defaultValue).setMergeValidator((o, n, c) -> o == n || o != false && n == false);
    }

    public static FieldMapper.Parameter<SimilarityProvider> similarity(Function<FieldMapper, SimilarityProvider> init) {
        return new FieldMapper.Parameter<SimilarityProvider>("similarity", false, () -> null, (n, c, o) -> TypeParsers.resolveSimilarity(c, n, o), init).setSerializer((b, f, v) -> b.field(f, v == null ? null : v.name()), v -> v == null ? null : v.name()).acceptsNull();
    }

    public static FieldMapper.Parameter<String> indexOptions(Function<FieldMapper, String> initializer) {
        return FieldMapper.Parameter.restrictedStringParam("index_options", false, initializer, "positions", "docs", "freqs", "offsets");
    }

    public static FieldType buildFieldType(Supplier<Boolean> indexed, Supplier<Boolean> stored, Supplier<String> indexOptions, Supplier<Boolean> norms, Supplier<String> termVectors) {
        FieldType ft = new FieldType();
        ft.setStored(stored.get());
        ft.setTokenized(true);
        ft.setIndexOptions(TextParams.toIndexOptions(indexed.get(), indexOptions.get()));
        ft.setOmitNorms(norms.get() == false);
        TextParams.setTermVectorParams(termVectors.get(), ft);
        return ft;
    }

    public static IndexOptions toIndexOptions(boolean indexed, String indexOptions) {
        if (!indexed) {
            return IndexOptions.NONE;
        }
        switch (indexOptions) {
            case "docs": {
                return IndexOptions.DOCS;
            }
            case "freqs": {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case "positions": {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case "offsets": {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw new IllegalArgumentException("Unknown [index_options] value: [" + indexOptions + "]");
    }

    public static FieldMapper.Parameter<String> termVectors(Function<FieldMapper, String> initializer) {
        return FieldMapper.Parameter.restrictedStringParam("term_vector", false, initializer, "no", "yes", "with_positions", "with_offsets", "with_positions_offsets", "with_positions_payloads", "with_positions_offsets_payloads");
    }

    public static void setTermVectorParams(String configuration, FieldType fieldType) {
        switch (configuration) {
            case "no": {
                fieldType.setStoreTermVectors(false);
                return;
            }
            case "yes": {
                fieldType.setStoreTermVectors(true);
                return;
            }
            case "with_positions": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorPositions(true);
                return;
            }
            case "with_offsets": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorOffsets(true);
                return;
            }
            case "with_positions_offsets": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorPositions(true);
                fieldType.setStoreTermVectorOffsets(true);
                return;
            }
            case "with_positions_payloads": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorPositions(true);
                fieldType.setStoreTermVectorPayloads(true);
                return;
            }
            case "with_positions_offsets_payloads": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorPositions(true);
                fieldType.setStoreTermVectorOffsets(true);
                fieldType.setStoreTermVectorPayloads(true);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown [term_vector] setting: [" + configuration + "]");
    }

    public static final class Analyzers {
        public final FieldMapper.Parameter<NamedAnalyzer> indexAnalyzer;
        public final FieldMapper.Parameter<NamedAnalyzer> searchAnalyzer;
        public final FieldMapper.Parameter<NamedAnalyzer> searchQuoteAnalyzer;
        public final FieldMapper.Parameter<Integer> positionIncrementGap;
        public final IndexAnalyzers indexAnalyzers;

        public Analyzers(IndexAnalyzers indexAnalyzers, Function<FieldMapper, NamedAnalyzer> analyzerInitFunction, Function<FieldMapper, Integer> positionGapInitFunction) {
            this.indexAnalyzer = FieldMapper.Parameter.analyzerParam("analyzer", false, analyzerInitFunction, indexAnalyzers::getDefaultIndexAnalyzer).setSerializerCheck((id, ic, a) -> id || ic || !Objects.equals(a, this.getSearchAnalyzer()) || !Objects.equals(a, this.getSearchQuoteAnalyzer())).addValidator(a -> a.checkAllowedInMode(AnalysisMode.INDEX_TIME));
            this.searchAnalyzer = FieldMapper.Parameter.analyzerParam("search_analyzer", true, m3 -> m3.fieldType().getTextSearchInfo().getSearchAnalyzer(), () -> {
                NamedAnalyzer defaultAnalyzer;
                if (!this.indexAnalyzer.isConfigured() && (defaultAnalyzer = indexAnalyzers.get("default_search")) != null) {
                    return defaultAnalyzer;
                }
                return this.indexAnalyzer.get();
            }).setSerializerCheck((id, ic, a) -> id || ic || !Objects.equals(a, this.getSearchQuoteAnalyzer())).addValidator(a -> a.checkAllowedInMode(AnalysisMode.SEARCH_TIME));
            this.searchQuoteAnalyzer = FieldMapper.Parameter.analyzerParam("search_quote_analyzer", true, m3 -> m3.fieldType().getTextSearchInfo().getSearchQuoteAnalyzer(), () -> {
                NamedAnalyzer defaultAnalyzer;
                if (!this.searchAnalyzer.isConfigured() && !this.indexAnalyzer.isConfigured() && (defaultAnalyzer = indexAnalyzers.get("default_search_quoted")) != null) {
                    return defaultAnalyzer;
                }
                return this.searchAnalyzer.get();
            }).addValidator(a -> a.checkAllowedInMode(AnalysisMode.SEARCH_TIME));
            this.positionIncrementGap = FieldMapper.Parameter.intParam("position_increment_gap", false, positionGapInitFunction, 100).addValidator(v -> {
                if (v < 0) {
                    throw new MapperParsingException("[position_increment_gap] must be positive, got [" + v + "]");
                }
            });
            this.indexAnalyzers = indexAnalyzers;
        }

        public NamedAnalyzer getIndexAnalyzer() {
            return this.wrapAnalyzer(this.indexAnalyzer.getValue());
        }

        public NamedAnalyzer getSearchAnalyzer() {
            return this.wrapAnalyzer(this.searchAnalyzer.getValue());
        }

        public NamedAnalyzer getSearchQuoteAnalyzer() {
            return this.wrapAnalyzer(this.searchQuoteAnalyzer.getValue());
        }

        private NamedAnalyzer wrapAnalyzer(NamedAnalyzer a) {
            if (!this.positionIncrementGap.isConfigured()) {
                return a;
            }
            return new NamedAnalyzer(a, this.positionIncrementGap.get());
        }
    }
}

