/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class ShardLongFieldRange
implements Writeable {
    public static final Version LONG_FIELD_RANGE_VERSION_INTRODUCED = Version.V_7_11_0;
    public static final ShardLongFieldRange EMPTY = new ShardLongFieldRange(Long.MAX_VALUE, Long.MIN_VALUE);
    public static final ShardLongFieldRange UNKNOWN = new ShardLongFieldRange(Long.MIN_VALUE, Long.MAX_VALUE);
    private final long min;
    private final long max;
    private static final byte WIRE_TYPE_OTHER = 0;
    private static final byte WIRE_TYPE_UNKNOWN = 1;
    private static final byte WIRE_TYPE_EMPTY = 2;

    public static ShardLongFieldRange of(long min2, long max) {
        assert (min2 <= max) : min2 + " vs " + max;
        return new ShardLongFieldRange(min2, max);
    }

    private ShardLongFieldRange(long min2, long max) {
        this.min = min2;
        this.max = max;
    }

    public long getMin() {
        assert (this != EMPTY && this != UNKNOWN && this.min <= this.max) : "must not use actual min of sentinel values";
        return this.min;
    }

    public long getMax() {
        assert (this != EMPTY && this != UNKNOWN && this.min <= this.max) : "must not use actual max of sentinel values";
        return this.max;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return "UNKNOWN";
        }
        if (this == EMPTY) {
            return "EMPTY";
        }
        return "[" + this.min + "-" + this.max + "]";
    }

    public static ShardLongFieldRange readFrom(StreamInput in) throws IOException {
        if (in.getVersion().before(LONG_FIELD_RANGE_VERSION_INTRODUCED)) {
            return UNKNOWN;
        }
        byte type = in.readByte();
        switch (type) {
            case 1: {
                return UNKNOWN;
            }
            case 2: {
                return EMPTY;
            }
            case 0: {
                return ShardLongFieldRange.of(in.readZLong(), in.readZLong());
            }
        }
        throw new IllegalStateException("type [" + type + "] not known");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(LONG_FIELD_RANGE_VERSION_INTRODUCED)) {
            if (this == UNKNOWN) {
                out.writeByte((byte)1);
            } else if (this == EMPTY) {
                out.writeByte((byte)2);
            } else {
                out.writeByte((byte)0);
                out.writeZLong(this.min);
                out.writeZLong(this.max);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this == EMPTY || this == UNKNOWN || o == EMPTY || o == UNKNOWN) {
            return false;
        }
        ShardLongFieldRange that = (ShardLongFieldRange)o;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }
}

