/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lz4;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.util.Utils;
import org.elasticsearch.lz4.LZ4SafeUtils;
import org.elasticsearch.lz4.LZ4Utils;
import org.elasticsearch.lz4.SafeUtils;

/*
 * Exception performing whole class analysis ignored.
 */
final class LZ4SafeUtils
extends Enum<LZ4SafeUtils> {
    private static final VarHandle intPlatformNative;
    private static final VarHandle longPlatformNative;
    private static final /* synthetic */ LZ4SafeUtils[] $VALUES;

    public static LZ4SafeUtils[] values() {
        return (LZ4SafeUtils[])$VALUES.clone();
    }

    public static LZ4SafeUtils valueOf(String name) {
        return Enum.valueOf(LZ4SafeUtils.class, name);
    }

    static int hash(byte[] buf, int i) {
        return LZ4Utils.hash(SafeUtils.readInt((byte[])buf, (int)i));
    }

    static int hash64k(byte[] buf, int i) {
        return LZ4Utils.hash64k(SafeUtils.readInt((byte[])buf, (int)i));
    }

    static boolean readIntEquals(byte[] buf, int i, int j) {
        return SafeUtils.readInt((byte[])buf, (int)i) == SafeUtils.readInt((byte[])buf, (int)j);
    }

    static void safeIncrementalCopy(byte[] dest, int matchOff, int dOff, int matchLen) {
        for (int i = 0; i < matchLen; ++i) {
            dest[dOff + i] = dest[matchOff + i];
        }
    }

    static void wildIncrementalCopy(byte[] dest, int matchOff, int dOff, int matchCopyEnd) {
        if (dOff - matchOff < 4) {
            for (int i = 0; i < 4; ++i) {
                dest[dOff + i] = dest[matchOff + i];
            }
            int dec = 0;
            assert ((dOff += 4) >= (matchOff += 4) && dOff - matchOff < 8);
            switch (dOff - matchOff) {
                case 1: {
                    matchOff -= 3;
                    break;
                }
                case 2: {
                    matchOff -= 2;
                    break;
                }
                case 3: {
                    matchOff -= 3;
                    dec = -1;
                    break;
                }
                case 5: {
                    dec = 1;
                    break;
                }
                case 6: {
                    dec = 2;
                    break;
                }
                case 7: {
                    dec = 3;
                    break;
                }
            }
            LZ4SafeUtils.copy4Bytes((byte[])dest, (int)matchOff, (byte[])dest, (int)dOff);
            dOff += 4;
            matchOff -= dec;
        } else if (dOff - matchOff < 8) {
            LZ4SafeUtils.copy8Bytes((byte[])dest, (int)matchOff, (byte[])dest, (int)dOff);
            dOff += dOff - matchOff;
        }
        while (dOff < matchCopyEnd) {
            LZ4SafeUtils.copy8Bytes((byte[])dest, (int)matchOff, (byte[])dest, (int)dOff);
            dOff += 8;
            matchOff += 8;
        }
    }

    static void copy8Bytes(byte[] src, int sOff, byte[] dest, int dOff) {
        longPlatformNative.set(dest, dOff, longPlatformNative.get(src, sOff));
    }

    static void copy4Bytes(byte[] src, int sOff, byte[] dest, int dOff) {
        intPlatformNative.set(dest, dOff, intPlatformNative.get(src, sOff));
    }

    static int commonBytes(byte[] b, int o1, int o2, int limit) {
        int mismatch = Arrays.mismatch(b, o1, limit, b, o2, limit);
        return mismatch == -1 ? limit : mismatch;
    }

    static int commonBytesBackward(byte[] b, int o1, int o2, int l1, int l2) {
        int count = 0;
        while (o1 > l1 && o2 > l2 && b[--o1] == b[--o2]) {
            ++count;
        }
        return count;
    }

    static void safeArraycopy(byte[] src, int sOff, byte[] dest, int dOff, int len) {
        System.arraycopy(src, sOff, dest, dOff, len);
    }

    static void wildArraycopy(byte[] src, int sOff, byte[] dest, int dOff, int len) {
        try {
            for (int i = 0; i < len; i += 8) {
                LZ4SafeUtils.copy8Bytes((byte[])src, (int)(sOff + i), (byte[])dest, (int)(dOff + i));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new LZ4Exception("Malformed input at offset " + sOff);
        }
    }

    static int encodeSequence(byte[] src, int anchor, int matchOff, int matchRef, int matchLen, byte[] dest, int dOff, int destEnd) {
        int token;
        int runLen = matchOff - anchor;
        int tokenOff = dOff++;
        if (dOff + runLen + 8 + (runLen >>> 8) > destEnd) {
            throw new LZ4Exception("maxDestLen is too small");
        }
        if (runLen >= 15) {
            token = -16;
            dOff = LZ4SafeUtils.writeLen((int)(runLen - 15), (byte[])dest, (int)dOff);
        } else {
            token = runLen << 4;
        }
        LZ4SafeUtils.wildArraycopy((byte[])src, (int)anchor, (byte[])dest, (int)dOff, (int)runLen);
        dOff += runLen;
        int matchDec = matchOff - matchRef;
        dest[dOff++] = (byte)matchDec;
        dest[dOff++] = (byte)(matchDec >>> 8);
        if (dOff + 6 + ((matchLen -= 4) >>> 8) > destEnd) {
            throw new LZ4Exception("maxDestLen is too small");
        }
        if (matchLen >= 15) {
            token |= 0xF;
            dOff = LZ4SafeUtils.writeLen((int)(matchLen - 15), (byte[])dest, (int)dOff);
        } else {
            token |= matchLen;
        }
        dest[tokenOff] = (byte)token;
        return dOff;
    }

    static int lastLiterals(byte[] src, int sOff, int srcLen, byte[] dest, int dOff, int destEnd) {
        int runLen = srcLen;
        if (dOff + runLen + 1 + (runLen + 255 - 15) / 255 > destEnd) {
            throw new LZ4Exception();
        }
        if (runLen >= 15) {
            dest[dOff++] = -16;
            dOff = LZ4SafeUtils.writeLen((int)(runLen - 15), (byte[])dest, (int)dOff);
        } else {
            dest[dOff++] = (byte)(runLen << 4);
        }
        System.arraycopy(src, sOff, dest, dOff, runLen);
        return dOff += runLen;
    }

    static int writeLen(int len, byte[] dest, int dOff) {
        while (len >= 255) {
            dest[dOff++] = -1;
            len -= 255;
        }
        dest[dOff++] = (byte)len;
        return dOff;
    }

    static void copyTo(Match m1, Match m22) {
        m22.len = m1.len;
        m22.start = m1.start;
        m22.ref = m1.ref;
    }

    private static /* synthetic */ LZ4SafeUtils[] $values() {
        return new LZ4SafeUtils[0];
    }

    static {
        $VALUES = LZ4SafeUtils.$values();
        intPlatformNative = MethodHandles.byteArrayViewVarHandle(int[].class, Utils.NATIVE_BYTE_ORDER);
        longPlatformNative = MethodHandles.byteArrayViewVarHandle(long[].class, Utils.NATIVE_BYTE_ORDER);
    }
}

