/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class CompositeFieldScript
extends AbstractFieldScript {
    public static final ScriptContext<Factory> CONTEXT = CompositeFieldScript.newContext("composite_field", Factory.class);
    public static final String[] PARAMETERS = new String[0];
    private final Map<String, List<Object>> fieldValues = new HashMap<String, List<Object>>();

    public CompositeFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx);
    }

    public final List<Object> getValues(String field) {
        this.fieldValues.clear();
        this.execute();
        List<Object> values = this.fieldValues.get(field);
        this.fieldValues.clear();
        return values;
    }

    public final Map<String, List<Object>> runForDoc(int doc) {
        this.setDocument(doc);
        this.fieldValues.clear();
        this.execute();
        return this.fieldValues;
    }

    protected final void emit(String field, Object value) {
        List values = this.fieldValues.computeIfAbsent(this.fieldName + "." + field, s2 -> new ArrayList());
        values.add(value);
    }

    @Override
    protected void emitFromObject(Object v) {
        throw new UnsupportedOperationException();
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3);
    }

    public static class EmitMap {
        private final CompositeFieldScript script;

        public EmitMap(CompositeFieldScript script) {
            this.script = script;
        }

        public void emit(Map<String, Object> subfields) {
            if (subfields == null) {
                return;
            }
            for (Map.Entry<String, Object> entry : subfields.entrySet()) {
                this.script.emit(entry.getKey(), entry.getValue());
            }
        }
    }

    public static class EmitField {
        private final CompositeFieldScript script;

        public EmitField(CompositeFieldScript script) {
            this.script = script;
        }

        public void emit(String field, Object value) {
            this.script.emit(field, value);
        }
    }

    public static interface LeafFactory {
        public CompositeFieldScript newInstance(LeafReaderContext var1);
    }
}

