/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.hadoop;

import cz.o2.proxima.direct.bulk.AbstractBulkFileSystemAttributeWriter;
import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.core.BulkAttributeWriter;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.hadoop.HadoopDataAccessor;
import cz.o2.proxima.direct.hadoop.HadoopFileSystem;
import cz.o2.proxima.direct.hadoop.HadoopPath;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.Serializable;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopBulkAttributeWriter
extends AbstractBulkFileSystemAttributeWriter {
    private static final Logger log = LoggerFactory.getLogger(HadoopBulkAttributeWriter.class);
    private final HadoopFileSystem targetFs;
    private final HadoopDataAccessor accessor;

    public HadoopBulkAttributeWriter(HadoopDataAccessor accessor, Context context) {
        super(accessor.getEntityDesc(), accessor.getUriRemapped(), (FileSystem)accessor.getTemporaryHadoopFs(), accessor.getTemporaryNamingConvention(), accessor.getFormat(), context, accessor.getRollInterval(), accessor.getAllowedLateness());
        this.targetFs = accessor.getHadoopFs();
        this.accessor = accessor;
    }

    public URI getUri() {
        return this.accessor.getUri();
    }

    protected void flush(AbstractBulkFileSystemAttributeWriter.Bulk bulk) {
        HadoopPath path = (HadoopPath)bulk.getPath();
        ExceptionUtils.unchecked((ExceptionUtils.ThrowingRunnable & Serializable)() -> path.move((HadoopPath)this.targetFs.newPath(bulk.getMaxTs() - this.getRollPeriodMs())));
        log.info("Flushed bulk {}", (Object)bulk);
    }

    public BulkAttributeWriter.Factory<?> asFactory() {
        HadoopDataAccessor accessor = this.accessor;
        Context context = this.getContext();
        return (BulkAttributeWriter.Factory & Serializable)repo -> new HadoopBulkAttributeWriter(accessor, context);
    }
}

