/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.hadoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import cz.o2.proxima.direct.batch.BatchLogReader;
import cz.o2.proxima.direct.bulk.FileFormat;
import cz.o2.proxima.direct.bulk.FileFormatUtils;
import cz.o2.proxima.direct.bulk.NamingConvention;
import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.core.DataAccessor;
import cz.o2.proxima.direct.hadoop.HadoopBatchLogReader;
import cz.o2.proxima.direct.hadoop.HadoopBulkAttributeWriter;
import cz.o2.proxima.direct.hadoop.HadoopFileSystem;
import cz.o2.proxima.direct.hadoop.HadoopStorage;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.repository.EntityDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopDataAccessor
implements DataAccessor {
    private static final Logger log = LoggerFactory.getLogger(HadoopDataAccessor.class);
    private static final long serialVersionUID = 1L;
    private static final String CFG_PREFIX = "hadoop";
    public static final String HADOOP_ROLL_INTERVAL = "hadoop.log-roll-interval";
    public static final String HADOOP_BATCH_PROCESS_SIZE_MIN = "hadoop.process-size.min";
    public static final String HADOOP_ALLOWED_LATENESS = "hadoop.allowed-lateness";
    public static final String TMP_FS = "hadoop.tmp.fs";
    static final long HADOOP_ROLL_INTERVAL_DEFAULT = TimeUnit.HOURS.toMillis(1L);
    static final long HADOOP_BATCH_PROCESS_SIZE_MIN_DEFAULT = 0x6400000L;
    private final EntityDescriptor entityDesc;
    private final URI uri;
    private final Map<String, Object> cfg;
    private final long rollInterval;
    private final long batchProcessSize;
    private final FileFormat format;
    private final NamingConvention namingConvention;
    private final NamingConvention temporaryNamingConvention;
    private final HadoopFileSystem hadoopFs;
    private final HadoopFileSystem temporaryHadoopFs;
    private final long allowedLateness;

    public HadoopDataAccessor(EntityDescriptor entityDesc, URI uri, Map<String, Object> cfg) {
        this.entityDesc = entityDesc;
        this.uri = uri;
        this.cfg = cfg;
        this.rollInterval = this.getCfg(HADOOP_ROLL_INTERVAL, cfg, (UnaryFunction & Serializable)o -> Long.valueOf(o.toString()), HADOOP_ROLL_INTERVAL_DEFAULT);
        this.batchProcessSize = this.getCfg(HADOOP_BATCH_PROCESS_SIZE_MIN, cfg, (UnaryFunction & Serializable)o -> Long.valueOf(o.toString()), 0x6400000L);
        this.format = FileFormatUtils.getFileFormat((String)"hadoop.", cfg);
        this.namingConvention = FileFormatUtils.getNamingConvention((String)"hadoop.", cfg, (long)this.rollInterval, (FileFormat)this.format);
        this.temporaryNamingConvention = NamingConvention.prefixed((String)"/_tmp", (NamingConvention)this.namingConvention);
        this.hadoopFs = new HadoopFileSystem(this);
        URI tmpFs = Optional.ofNullable(cfg.get(TMP_FS)).map(Object::toString).map(URI::create).orElse(this.hadoopFs.getUri());
        this.temporaryHadoopFs = new HadoopFileSystem(tmpFs, this, this.temporaryNamingConvention);
        this.allowedLateness = this.getCfg(HADOOP_ALLOWED_LATENESS, cfg, (UnaryFunction & Serializable)o -> Long.valueOf(o.toString()), 0L);
        Preconditions.checkArgument((this.rollInterval != 0L ? 1 : 0) != 0, (String)"Use non-negative %s got %s", (Object[])new Object[]{HADOOP_ROLL_INTERVAL, this.rollInterval});
        Preconditions.checkArgument((this.allowedLateness >= 0L ? 1 : 0) != 0, (String)"Use non-negative %s got %s", (Object[])new Object[]{HADOOP_ALLOWED_LATENESS, this.allowedLateness});
    }

    public Map<String, Object> getCfg() {
        return Collections.unmodifiableMap(this.cfg);
    }

    public Optional<AttributeWriterBase> getWriter(Context context) {
        return this.newWriter(context);
    }

    @VisibleForTesting
    Optional<AttributeWriterBase> newWriter(Context context) {
        return Optional.of(new HadoopBulkAttributeWriter(this, context));
    }

    public Optional<BatchLogReader> getBatchLogReader(Context context) {
        return Optional.of(new HadoopBatchLogReader(this, context));
    }

    private <T> T getCfg(String name, Map<String, Object> cfg, UnaryFunction<Object, T> convert, T defVal) {
        return (T)Optional.ofNullable(cfg.get(name)).map(arg_0 -> convert.apply(arg_0)).orElse(defVal);
    }

    FileSystem getFsFor(URI uri) {
        try {
            return FileSystem.get((URI)uri, (Configuration)this.getHadoopConf());
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to get filesystem for URI: " + uri, ex);
        }
    }

    Configuration getHadoopConf() {
        Configuration conf = new Configuration();
        this.cfg.forEach((key, value) -> conf.set(key, value.toString()));
        return conf;
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HadoopDataAccessor) {
            HadoopDataAccessor other = (HadoopDataAccessor)obj;
            return other.getUri().equals(this.getUri());
        }
        return false;
    }

    public URI getUriRemapped() {
        return HadoopStorage.remap(this.getUri());
    }

    public String toString() {
        return "HadoopDataAccessor(entityDesc=" + this.getEntityDesc() + ", uri=" + this.getUri() + ", cfg=" + this.getCfg() + ", rollInterval=" + this.getRollInterval() + ", batchProcessSize=" + this.getBatchProcessSize() + ", format=" + this.getFormat() + ", namingConvention=" + this.getNamingConvention() + ", temporaryNamingConvention=" + this.getTemporaryNamingConvention() + ", hadoopFs=" + this.getHadoopFs() + ", temporaryHadoopFs=" + this.getTemporaryHadoopFs() + ", allowedLateness=" + this.getAllowedLateness() + ")";
    }

    public EntityDescriptor getEntityDesc() {
        return this.entityDesc;
    }

    public URI getUri() {
        return this.uri;
    }

    public long getRollInterval() {
        return this.rollInterval;
    }

    public long getBatchProcessSize() {
        return this.batchProcessSize;
    }

    public FileFormat getFormat() {
        return this.format;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public NamingConvention getTemporaryNamingConvention() {
        return this.temporaryNamingConvention;
    }

    public HadoopFileSystem getHadoopFs() {
        return this.hadoopFs;
    }

    public HadoopFileSystem getTemporaryHadoopFs() {
        return this.temporaryHadoopFs;
    }

    public long getAllowedLateness() {
        return this.allowedLateness;
    }
}

