/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.hadoop;

import cz.o2.proxima.direct.bulk.FileSystem;
import cz.o2.proxima.direct.bulk.NamingConvention;
import cz.o2.proxima.direct.hadoop.HadoopDataAccessor;
import cz.o2.proxima.direct.hadoop.HadoopPath;
import cz.o2.proxima.direct.hadoop.HadoopStorage;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.Serializable;
import java.net.URI;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

class HadoopFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private final URI uri;
    private final HadoopDataAccessor accessor;
    private final NamingConvention namingConvention;
    private transient org.apache.hadoop.fs.FileSystem fs = null;

    HadoopFileSystem(HadoopDataAccessor accessor) {
        this(accessor, accessor.getNamingConvention());
    }

    HadoopFileSystem(HadoopDataAccessor accessor, NamingConvention namingConvention) {
        this(accessor.getUri(), accessor, namingConvention);
    }

    HadoopFileSystem(URI uri, HadoopDataAccessor accessor, NamingConvention namingConvention) {
        this.uri = uri;
        this.accessor = accessor;
        this.namingConvention = namingConvention;
    }

    public URI getUri() {
        return this.uri;
    }

    public Stream<cz.o2.proxima.direct.bulk.Path> list(long minTs, long maxTs) {
        URI remappedUri = HadoopStorage.remap(this.getUri());
        RemoteIterator iterator = (RemoteIterator)ExceptionUtils.uncheckedFactory((ExceptionUtils.ThrowingFactory & Serializable)() -> this.fs().listFiles(new Path(remappedUri), true));
        Spliterator<LocatedFileStatus> spliterator = this.asSpliterator((RemoteIterator<LocatedFileStatus>)iterator);
        return StreamSupport.stream(spliterator, false).filter(FileStatus::isFile).map(f -> f.getPath().toUri().toString().substring(remappedUri.toString().length())).filter(name -> this.namingConvention.isInRange(name, minTs, maxTs)).map(name -> HadoopPath.of(this, remappedUri + name, this.accessor));
    }

    private Spliterator<LocatedFileStatus> asSpliterator(final RemoteIterator<LocatedFileStatus> iterator) {
        return new Spliterators.AbstractSpliterator<LocatedFileStatus>(-1L, 0){

            @Override
            public boolean tryAdvance(Consumer<? super LocatedFileStatus> consumer) {
                if (((Boolean)ExceptionUtils.uncheckedFactory(() -> ((RemoteIterator)iterator).hasNext())).booleanValue()) {
                    consumer.accept((LocatedFileStatus)ExceptionUtils.uncheckedFactory(() -> ((RemoteIterator)iterator).next()));
                    return true;
                }
                return false;
            }
        };
    }

    public cz.o2.proxima.direct.bulk.Path newPath(long ts) {
        String path = HadoopStorage.remap(this.getUri()) + this.namingConvention.nameOf(ts);
        return HadoopPath.of(this, path, this.accessor);
    }

    private org.apache.hadoop.fs.FileSystem fs() {
        if (this.fs == null) {
            this.fs = this.accessor.getFsFor(HadoopStorage.remap(this.getUri()));
        }
        return this.fs;
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HadoopFileSystem) {
            HadoopFileSystem other = (HadoopFileSystem)obj;
            return other.getUri().equals(this.getUri());
        }
        return false;
    }
}

