/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.hadoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import cz.o2.proxima.direct.hadoop.HadoopDataAccessor;
import cz.o2.proxima.direct.hadoop.HadoopFileSystem;
import cz.o2.proxima.direct.hadoop.HadoopStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HadoopPath
implements cz.o2.proxima.direct.bulk.Path {
    private static final Logger log = LoggerFactory.getLogger(HadoopPath.class);
    private static final long serialVersionUID = 1L;
    private final HadoopFileSystem fs;
    private final URI path;
    private final HadoopDataAccessor accessor;

    static HadoopPath of(HadoopFileSystem fs, String path, HadoopDataAccessor accessor) {
        return new HadoopPath(fs, path, accessor);
    }

    private HadoopPath(HadoopFileSystem fs, String path, HadoopDataAccessor accessor) {
        this.fs = fs;
        this.path = HadoopStorage.remap(URI.create(path));
        this.accessor = accessor;
        Preconditions.checkArgument((this.path.isAbsolute() && !Strings.isNullOrEmpty((String)this.path.getScheme()) ? 1 : 0) != 0, (String)"Passed path must be absolute URL, got [%s]", (Object[])new Object[]{path});
    }

    public InputStream reader() throws IOException {
        Path p = this.toPath();
        return p.getFileSystem(this.accessor.getHadoopConf()).open(p);
    }

    public OutputStream writer() throws IOException {
        Path p = this.toPath();
        return p.getFileSystem(this.accessor.getHadoopConf()).create(p);
    }

    public cz.o2.proxima.direct.bulk.FileSystem getFileSystem() {
        return this.fs;
    }

    public void delete() throws IOException {
        Path p = this.toPath();
        p.getFileSystem(this.accessor.getHadoopConf()).delete(p, true);
    }

    public String toString() {
        return "HadoopPath(" + this.path.toASCIIString() + ")";
    }

    public void move(HadoopPath target) throws IOException {
        if (this.getFileSystem().getUri().equals(target.getFileSystem().getUri())) {
            this.renameOnFs(target);
        } else {
            this.moveToRemote(target);
        }
    }

    @VisibleForTesting
    void renameOnFs(HadoopPath target) throws IOException {
        Path sourcePath = this.toPath();
        Path targetPath = target.toPath();
        Path parentPath = targetPath.getParent();
        FileSystem hadoopFs = targetPath.getFileSystem(this.accessor.getHadoopConf());
        if (!hadoopFs.exists(parentPath)) {
            Preconditions.checkState((boolean)hadoopFs.mkdirs(parentPath), (String)"Failed to mkdirs on %s", (Object[])new Object[]{parentPath});
        }
        hadoopFs.rename(sourcePath, targetPath);
        log.debug("Renamed {} to {}", (Object)sourcePath, (Object)target);
    }

    @VisibleForTesting
    void moveToRemote(HadoopPath target) throws IOException {
        try (InputStream in = this.reader();
             OutputStream output = target.writer();){
            IOUtils.copy((InputStream)in, (OutputStream)output);
        }
        this.delete();
    }

    public FileStatus getFileStatus() throws IOException {
        Path p = this.toPath();
        return p.getFileSystem(this.accessor.getHadoopConf()).getFileStatus(p);
    }

    private Path toPath() {
        return new Path(this.path);
    }

    public boolean isTmpPath() {
        return this.path.toString().startsWith(this.accessor.getUriRemapped() + "/_tmp");
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HadoopPath)) {
            return false;
        }
        HadoopPath other = (HadoopPath)obj;
        return other.getPath().equals(this.getPath());
    }

    public int compareTo(cz.o2.proxima.direct.bulk.Path other) {
        return this.path.compareTo(((HadoopPath)other).getPath());
    }

    public URI getPath() {
        return this.path;
    }
}

