/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import cz.o2.proxima.direct.core.DataAccessor;
import cz.o2.proxima.direct.core.DataAccessorFactory;
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.direct.hadoop.HadoopDataAccessor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.internal.AbstractDataAccessorFactory;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStorage
implements DataAccessorFactory {
    private static final Logger log = LoggerFactory.getLogger(HadoopStorage.class);
    private static final long serialVersionUID = 1L;

    public DataAccessor createAccessor(DirectDataOperator direct, EntityDescriptor entityDesc, URI uri, Map<String, Object> cfg) {
        return new HadoopDataAccessor(entityDesc, uri, cfg);
    }

    static URI remap(URI input) {
        if (input.getScheme().equals("hadoop")) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)input.getSchemeSpecificPart()) && !("//" + input.getPath()).equals(input.getSchemeSpecificPart()) ? 1 : 0) != 0, (Object)"When using generic `hadoop` scheme, please use scheme-specific part for actual filesystem scheme (e.g. hadoop:file:///)");
            return URI.create(input.getSchemeSpecificPart());
        }
        return input;
    }

    public AbstractDataAccessorFactory.Accept accepts(URI uri) {
        return uri.getScheme().equals("hdfs") || uri.getScheme().equals("hadoop") ? AbstractDataAccessorFactory.Accept.ACCEPT : AbstractDataAccessorFactory.Accept.REJECT;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HadoopStorage)) {
            return false;
        }
        HadoopStorage other = (HadoopStorage)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof HadoopStorage;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

