/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.hbase;

import cz.o2.proxima.direct.hbase.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HBaseClientWrapper
implements AutoCloseable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(HBaseClientWrapper.class);
    final URI uri;
    final byte[] serializedConf;
    final byte[] family;
    transient Connection conn;
    transient Table client;

    HBaseClientWrapper(URI uri, Configuration conf) {
        this.uri = uri;
        this.family = Util.getFamily(uri);
        this.serializedConf = HBaseClientWrapper.serialize((Writable)HBaseConfiguration.create((Configuration)conf));
    }

    public URI getUri() {
        return this.uri;
    }

    void ensureClient() {
        if (this.conn == null || this.conn.isClosed()) {
            try {
                if (this.client != null) {
                    this.client.close();
                }
                if (this.conn != null && !this.conn.isClosed()) {
                    this.conn.close();
                }
                this.conn = ConnectionFactory.createConnection((Configuration)HBaseClientWrapper.deserialize(this.serializedConf, new Configuration()));
                this.client = this.conn.getTable(this.tableName());
            }
            catch (IOException ex) {
                log.error("Error connecting to cluster", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    TableName tableName() {
        return TableName.valueOf((String)Util.getTable(this.uri));
    }

    @Override
    public void close() {
        if (this.client != null) {
            Util.closeQuietly((AutoCloseable)this.client);
            this.client = null;
        }
        if (this.conn != null) {
            Util.closeQuietly((AutoCloseable)this.conn);
            this.conn = null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] serialize(Writable obj) {
        try {
            Throwable throwable = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                DataOutputStream dos = new DataOutputStream(baos);
                Throwable throwable2 = null;
                try {
                    obj.write((DataOutput)dos);
                    dos.flush();
                    byArray = baos.toByteArray();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            HBaseClientWrapper.$closeResource(throwable2, dos);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                HBaseClientWrapper.$closeResource(throwable2, dos);
                return byArray;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <W extends Writable> W deserialize(byte[] bytes, W obj) {
        try {
            Throwable throwable = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
                W w;
                DataInputStream dis = new DataInputStream(bais);
                Throwable throwable2 = null;
                try {
                    obj.readFields((DataInput)dis);
                    w = obj;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            HBaseClientWrapper.$closeResource(throwable2, dis);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                HBaseClientWrapper.$closeResource(throwable2, dis);
                return w;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

