/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.hbase;

import cz.o2.proxima.direct.batch.BatchLogObservable;
import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.core.DataAccessor;
import cz.o2.proxima.direct.hbase.HBaseLogObservable;
import cz.o2.proxima.direct.hbase.HBaseWriter;
import cz.o2.proxima.direct.hbase.RandomHBaseReader;
import cz.o2.proxima.direct.hbase.Util;
import cz.o2.proxima.direct.randomaccess.RandomAccessReader;
import cz.o2.proxima.functional.BiFunction;
import cz.o2.proxima.functional.Factory;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.AbstractStorage;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;

public class HBaseDataAccessor
extends AbstractStorage
implements DataAccessor {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> cfg;
    private final ConfFactory confFactory;

    public HBaseDataAccessor(EntityDescriptor entity, URI uri, Map<String, Object> cfg) {
        this(entity, uri, cfg, (ConfFactory & Serializable)(m, u) -> Util.getConf(u));
    }

    public HBaseDataAccessor(EntityDescriptor entity, URI uri, Map<String, Object> cfg, ConfFactory confFactory) {
        super(entity, uri);
        this.cfg = cfg;
        this.confFactory = confFactory;
    }

    public Optional<AttributeWriterBase> getWriter(Context context) {
        return Optional.of(new HBaseWriter(this.getUri(), this.getConf(), this.cfg));
    }

    public Optional<RandomAccessReader> getRandomAccessReader(Context context) {
        return Optional.of(new RandomHBaseReader(this.getUri(), this.getConf(), this.cfg, this.getEntityDescriptor()));
    }

    public Optional<BatchLogObservable> getBatchLogObservable(Context context) {
        return Optional.of(new HBaseLogObservable(this.getUri(), this.getConf(), this.getEntityDescriptor(), (Factory<Executor>)((Factory & Serializable)() -> ((Context)context).getExecutorService())));
    }

    private Configuration getConf() {
        return HBaseConfiguration.create((Configuration)((Configuration)this.confFactory.apply(this.cfg, this.getUri())));
    }

    public static interface ConfFactory
    extends BiFunction<Map<String, Object>, URI, Configuration> {
    }
}

