/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.hbase;

import cz.o2.proxima.direct.hbase.HBaseClientWrapper;
import cz.o2.proxima.direct.hbase.Util;
import cz.o2.proxima.direct.randomaccess.KeyValue;
import cz.o2.proxima.direct.randomaccess.RandomAccessReader;
import cz.o2.proxima.direct.randomaccess.RandomOffset;
import cz.o2.proxima.direct.randomaccess.RawOffset;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomHBaseReader
extends HBaseClientWrapper
implements RandomAccessReader {
    private static final Logger log = LoggerFactory.getLogger(RandomHBaseReader.class);
    private static final String KEYS_SCANNER_CACHING = "hbase.list-keys.caching";
    private static final int KEYS_SCANNER_CACHING_DEFAULT = 1000;
    private final EntityDescriptor entity;
    private final int keyCaching;

    public RandomHBaseReader(URI uri, Configuration conf, Map<String, Object> cfg, EntityDescriptor entity) {
        super(uri, conf);
        this.entity = entity;
        this.keyCaching = Integer.parseInt(Optional.ofNullable(cfg.get(KEYS_SCANNER_CACHING)).orElse(1000).toString());
    }

    public RandomOffset fetchOffset(RandomAccessReader.Listing type, String key) {
        return RandomHBaseReader.asOffset(key);
    }

    public <T> Optional<KeyValue<T>> get(String key, String attribute, AttributeDescriptor<T> desc, long stamp) {
        this.ensureClient();
        byte[] qualifier = attribute.getBytes(StandardCharsets.UTF_8);
        Get get = new Get(key.getBytes(StandardCharsets.UTF_8));
        get.addColumn(this.family, qualifier);
        try {
            Result res = this.client.get(get);
            Cell cell = res.getColumnLatestCell(this.family, qualifier);
            return Optional.ofNullable(cell == null ? null : this.kv(desc, cell));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> void scanWildcard(String key, AttributeDescriptor<T> wildcard, RandomOffset offset, long stamp, int limit, Consumer<KeyValue<T>> consumer) {
        try {
            this.ensureClient();
            RawOffset stroff = (RawOffset)offset;
            Get get = new Get(key.getBytes(StandardCharsets.UTF_8));
            get.addFamily(this.family);
            get.setFilter((Filter)new ColumnPrefixFilter(wildcard.toAttributePrefix().getBytes(StandardCharsets.UTF_8)));
            Scan scan = new Scan(get);
            if (limit <= 0) {
                limit = Integer.MAX_VALUE;
            }
            scan.setBatch(limit);
            if (stroff != null) {
                scan.setFilter((Filter)new ColumnPaginationFilter(limit, (stroff.getOffset() + '\u0000').getBytes(StandardCharsets.UTF_8)));
            }
            int accepted = 0;
            try (ResultScanner scanner = this.client.getScanner(scan);){
                Result next;
                while (accepted < limit && (next = scanner.next()) != null) {
                    CellScanner cellScanner = next.cellScanner();
                    while (cellScanner.advance() && accepted++ < limit) {
                        Cell cell = cellScanner.current();
                        consumer.accept((Object)this.kv(wildcard, cell));
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void listEntities(RandomOffset offset, int limit, Consumer<Pair<RandomOffset, String>> consumer) {
        this.ensureClient();
        Scan s = offset == null ? new Scan() : new Scan((((RawOffset)offset).getOffset() + '\u0000').getBytes(StandardCharsets.UTF_8));
        s.addFamily(this.family);
        s.setFilter((Filter)new KeyOnlyFilter());
        s.setCaching(this.keyCaching);
        try (ResultScanner scanner = this.client.getScanner(s);){
            Result res;
            int taken = 0;
            while ((limit <= 0 || taken++ < limit) && (res = scanner.next()) != null) {
                String key = new String(res.getRow());
                consumer.accept((Object)Pair.of((Object)RandomHBaseReader.asOffset(key), (Object)key));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            Util.closeQuietly((AutoCloseable)this.client);
            this.client = null;
        }
    }

    private KeyValue kv(AttributeDescriptor<?> desc, Cell cell) {
        String key = new String(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
        String attribute = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        return KeyValue.of((EntityDescriptor)this.entity, desc, (String)key, (String)attribute, (RandomOffset)RandomHBaseReader.asOffset(attribute), (byte[])Util.cloneArray(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()), (long)cell.getTimestamp());
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entity;
    }

    public void scanWildcardAll(String key, RandomOffset offset, long stamp, int limit, Consumer<KeyValue<?>> consumer) {
        throw new UnsupportedOperationException("Unsupported. See https://github.com/O2-Czech-Republic/proxima-platform/issues/68");
    }

    static RawOffset asOffset(String what) {
        return new RawOffset(what);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomHBaseReader)) {
            return false;
        }
        RandomHBaseReader other = (RandomHBaseReader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityDescriptor this$entity = this.entity;
        EntityDescriptor other$entity = other.entity;
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        return this.keyCaching == other.keyCaching;
    }

    protected boolean canEqual(Object other) {
        return other instanceof RandomHBaseReader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityDescriptor $entity = this.entity;
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        result = result * 59 + this.keyCaching;
        return result;
    }
}

