/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.hbase;

import com.google.common.base.Preconditions;
import cz.o2.proxima.storage.UriUtil;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    private static final String FAMILY_QUERY = "family";

    static Configuration getConf(URI uri) {
        Configuration conf = HBaseConfiguration.create();
        List paths = UriUtil.parsePath((URI)uri);
        if (paths.size() > 1) {
            conf.set("zookeeper.znode.parent", String.join((CharSequence)"/", paths.subList(0, paths.size() - 1)));
        }
        conf.set("hbase.zookeeper.quorum", uri.getAuthority());
        return conf;
    }

    static String getTable(URI uri) {
        List paths = UriUtil.parsePath((URI)uri);
        Preconditions.checkArgument((!paths.isEmpty() ? 1 : 0) != 0, (String)"Table cannot be empty in uri: {}!", (Object[])new Object[]{uri});
        return (String)paths.get(paths.size() - 1);
    }

    static byte[] getFamily(URI uri) {
        return Optional.ofNullable((String)UriUtil.parseQuery((URI)uri).get(FAMILY_QUERY)).map(String::getBytes).orElseThrow(() -> new IllegalArgumentException("Query family is missing!"));
    }

    static void closeQuietly(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception ex) {
            log.warn("Failed to close {}. Ignored.", (Object)closeable, (Object)ex);
        }
    }

    static byte[] cloneArray(byte[] array, int offset, int length) {
        byte[] ret = new byte[length];
        System.arraycopy(array, offset, ret, 0, length);
        return ret;
    }

    private Util() {
    }
}

