/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.io.kafka;

import cz.o2.proxima.internal.com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;

class KafkaThroughputLimiter {
    private final long desiredBytesPerSec;

    KafkaThroughputLimiter(long maxBytesPerSec) {
        this.desiredBytesPerSec = maxBytesPerSec < Long.MAX_VALUE ? Math.max(1L, maxBytesPerSec) : Long.MAX_VALUE;
    }

    public void sleepToLimitThroughput(long bytesPolled, long pollTimeMs) throws InterruptedException {
        long sleepTimeMs;
        if (this.desiredBytesPerSec < Long.MAX_VALUE && (sleepTimeMs = this.getSleepTime(bytesPolled, pollTimeMs)) > 0L) {
            TimeUnit.MILLISECONDS.sleep(sleepTimeMs);
        }
    }

    @VisibleForTesting
    long getSleepTime(long bytesPolled, long pollTimeMs) {
        long currentBytesPerSec = bytesPolled * 1000L / Math.max(pollTimeMs, 1L);
        if (currentBytesPerSec > this.desiredBytesPerSec) {
            return Math.max(currentBytesPerSec / this.desiredBytesPerSec * pollTimeMs - pollTimeMs, 0L);
        }
        return 0L;
    }
}

