/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.io.kafka;

import cz.o2.proxima.direct.core.commitlog.Offset;
import cz.o2.proxima.direct.io.kafka.PartitionWithTopic;
import cz.o2.proxima.internal.com.google.common.base.MoreObjects;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

class TopicOffset
implements Offset {
    private static final long serialVersionUID = 1L;
    private final PartitionWithTopic partition;
    private final long offset;
    private final long watermark;

    TopicOffset(PartitionWithTopic partition, long offset, long watermark) {
        this.partition = partition;
        this.offset = offset;
        this.watermark = watermark;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partition", (Object)this.partition).add("offset", this.offset).add("watermark", this.watermark).toString();
    }

    public PartitionWithTopic getPartition() {
        return this.partition;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TopicOffset) {
            TopicOffset other = (TopicOffset)obj;
            return other.partition.equals(this.partition) && other.offset == this.offset;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.offset);
    }

    static List<TopicOffset> fromMap(Map<TopicPartition, Long> offsetMap, long watermark) {
        return offsetMap.entrySet().stream().map(e -> new TopicOffset(new PartitionWithTopic(((TopicPartition)e.getKey()).topic(), ((TopicPartition)e.getKey()).partition()), (Long)e.getValue(), watermark)).collect(Collectors.toList());
    }

    @Generated
    public long getOffset() {
        return this.offset;
    }

    @Generated
    public long getWatermark() {
        return this.watermark;
    }
}

