/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.io.kafka;

import cz.o2.proxima.core.scheme.SerializationException;
import cz.o2.proxima.direct.core.commitlog.Offset;
import cz.o2.proxima.direct.core.commitlog.OffsetExternalizer;
import cz.o2.proxima.direct.io.kafka.PartitionWithTopic;
import cz.o2.proxima.direct.io.kafka.TopicOffset;
import cz.o2.proxima.internal.com.google.gson.JsonObject;
import cz.o2.proxima.internal.com.google.gson.JsonParser;

class TopicOffsetExternalizer
implements OffsetExternalizer {
    TopicOffsetExternalizer() {
    }

    public String toJson(Offset offset) {
        TopicOffset topicOffset = (TopicOffset)offset;
        JsonObject json = new JsonObject();
        json.addProperty("topic", topicOffset.getPartition().getTopic());
        json.addProperty("partition", (Number)topicOffset.getPartition().getPartition());
        json.addProperty("offset", (Number)topicOffset.getOffset());
        json.addProperty("watermark", (Number)topicOffset.getWatermark());
        return json.toString();
    }

    public TopicOffset fromJson(String json) {
        try {
            JsonObject object = JsonParser.parseString((String)json).getAsJsonObject();
            PartitionWithTopic partitionWithTopic = new PartitionWithTopic(object.get("topic").getAsString(), object.get("partition").getAsInt());
            return new TopicOffset(partitionWithTopic, object.get("offset").getAsLong(), object.get("watermark").getAsLong());
        }
        catch (Exception ex) {
            throw new SerializationException("Failed to deserialize " + json, (Throwable)ex);
        }
    }
}

