/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.io.kafka;

import cz.o2.proxima.core.storage.UriUtil;
import cz.o2.proxima.direct.core.commitlog.Offset;
import cz.o2.proxima.direct.io.kafka.TopicOffset;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import java.net.URI;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class Utils {
    static final String TOPIC_PATTERN_QUERY = "topicPattern";

    @Nullable
    static String topic(URI uri) {
        String topic = UriUtil.getPathNormalized((URI)uri);
        if (topic.isEmpty()) {
            return null;
        }
        return topic;
    }

    @Nullable
    static String topicPattern(URI uri) {
        String pattern = (String)UriUtil.parseQuery((URI)uri).get(TOPIC_PATTERN_QUERY);
        if (pattern != null) {
            try {
                Pattern.compile(pattern);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(String.format("Cannot parse topic pattern %s from URI %s", pattern, uri), ex);
            }
        }
        return pattern;
    }

    static void seekToOffsets(Collection<? extends Offset> offsets, KafkaConsumer<?, ?> consumer) {
        offsets.forEach(o -> {
            TopicOffset to = (TopicOffset)o;
            if (to.getOffset() >= 0L) {
                consumer.seek(new TopicPartition(to.getPartition().getTopic(), to.getPartition().getPartition()), to.getOffset());
            }
        });
    }

    private Utils() {
    }
}

