/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.io.kafka.serializer;

import cz.o2.proxima.core.functional.UnaryFunction;
import cz.o2.proxima.core.repository.AttributeDescriptor;
import cz.o2.proxima.core.repository.EntityDescriptor;
import cz.o2.proxima.core.storage.StreamElement;
import cz.o2.proxima.direct.io.kafka.ElementSerializer;
import cz.o2.proxima.internal.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.serialization.Serde;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.serialization.Serdes;
import java.io.Serializable;
import javax.annotation.Nullable;

public class ValueAsBytesSerializer
implements ElementSerializer<byte[], byte[]> {
    private static final long serialVersionUID = 1L;
    private final UnaryFunction<EntityDescriptor, AttributeDescriptor<byte[]>> readAttributeFn;
    private AttributeDescriptor<byte[]> attr;

    protected ValueAsBytesSerializer(String attrName) {
        this((UnaryFunction<EntityDescriptor, AttributeDescriptor<byte[]>>)(UnaryFunction & Serializable)desc -> desc.getAttribute(attrName));
    }

    protected ValueAsBytesSerializer(UnaryFunction<EntityDescriptor, AttributeDescriptor<byte[]>> readAttributeFn) {
        this.readAttributeFn = readAttributeFn;
    }

    @Override
    public void setup(EntityDescriptor entityDescriptor) {
        this.attr = (AttributeDescriptor)this.readAttributeFn.apply((Object)entityDescriptor);
    }

    @Override
    @Nullable
    public StreamElement read(ConsumerRecord<byte[], byte[]> consumerRecord, EntityDescriptor entityDescriptor) {
        return this.parseValue(entityDescriptor, consumerRecord.value(), consumerRecord.partition(), consumerRecord.offset(), consumerRecord.timestamp());
    }

    @Nullable
    @VisibleForTesting
    StreamElement parseValue(EntityDescriptor entityDescriptor, byte[] value, int partition, long offset, long timestamp) {
        String uuid = partition + ":" + offset;
        if (this.attr.isWildcard()) {
            return StreamElement.upsert((EntityDescriptor)entityDescriptor, this.attr, (String)uuid, (String)uuid, (String)(this.attr.toAttributePrefix() + uuid), (long)timestamp, (byte[])value);
        }
        return StreamElement.upsert((EntityDescriptor)entityDescriptor, this.attr, (String)uuid, (String)uuid, (String)this.attr.getName(), (long)timestamp, (byte[])value);
    }

    @Override
    public ProducerRecord<byte[], byte[]> write(String topic, int partition, StreamElement streamElement) {
        throw new UnsupportedOperationException("Readonly storage!");
    }

    @Override
    public Serde<byte[]> keySerde() {
        return Serdes.ByteArray();
    }

    @Override
    public Serde<byte[]> valueSerde() {
        return Serdes.ByteArray();
    }
}

