/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin.Config;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.KafkaFuture;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.Uuid;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.ApiException;
import java.util.Map;
import java.util.stream.Collectors;

@InterfaceStability.Evolving
public class CreateTopicsResult {
    static final int UNKNOWN = -1;
    private final Map<String, KafkaFuture<TopicMetadataAndConfig>> futures;

    protected CreateTopicsResult(Map<String, KafkaFuture<TopicMetadataAndConfig>> futures) {
        this.futures = futures;
    }

    public Map<String, KafkaFuture<Void>> values() {
        return this.futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((KafkaFuture)e.getValue()).thenApply(v -> null)));
    }

    public KafkaFuture<Void> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0]));
    }

    public KafkaFuture<Config> config(String topic) {
        return this.futures.get(topic).thenApply(TopicMetadataAndConfig::config);
    }

    public KafkaFuture<Uuid> topicId(String topic) {
        return this.futures.get(topic).thenApply(TopicMetadataAndConfig::topicId);
    }

    public KafkaFuture<Integer> numPartitions(String topic) {
        return this.futures.get(topic).thenApply(TopicMetadataAndConfig::numPartitions);
    }

    public KafkaFuture<Integer> replicationFactor(String topic) {
        return this.futures.get(topic).thenApply(TopicMetadataAndConfig::replicationFactor);
    }

    public static class TopicMetadataAndConfig {
        private final ApiException exception;
        private final Uuid topicId;
        private final int numPartitions;
        private final int replicationFactor;
        private final Config config;

        TopicMetadataAndConfig(Uuid topicId, int numPartitions, int replicationFactor, Config config) {
            this.exception = null;
            this.topicId = topicId;
            this.numPartitions = numPartitions;
            this.replicationFactor = replicationFactor;
            this.config = config;
        }

        TopicMetadataAndConfig(ApiException exception) {
            this.exception = exception;
            this.topicId = Uuid.ZERO_UUID;
            this.numPartitions = -1;
            this.replicationFactor = -1;
            this.config = null;
        }

        public Uuid topicId() {
            this.ensureSuccess();
            return this.topicId;
        }

        public int numPartitions() {
            this.ensureSuccess();
            return this.numPartitions;
        }

        public int replicationFactor() {
            this.ensureSuccess();
            return this.replicationFactor;
        }

        public Config config() {
            this.ensureSuccess();
            return this.config;
        }

        private void ensureSuccess() {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

