/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin;

import java.util.Objects;

public class FeatureUpdate {
    private final short maxVersionLevel;
    private final boolean allowDowngrade;

    public FeatureUpdate(short maxVersionLevel, boolean allowDowngrade) {
        if (maxVersionLevel < 1 && !allowDowngrade) {
            throw new IllegalArgumentException(String.format("The allowDowngrade flag should be set when the provided maxVersionLevel:%d is < 1.", maxVersionLevel));
        }
        this.maxVersionLevel = maxVersionLevel;
        this.allowDowngrade = allowDowngrade;
    }

    public short maxVersionLevel() {
        return this.maxVersionLevel;
    }

    public boolean allowDowngrade() {
        return this.allowDowngrade;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FeatureUpdate)) {
            return false;
        }
        FeatureUpdate that = (FeatureUpdate)other;
        return this.maxVersionLevel == that.maxVersionLevel && this.allowDowngrade == that.allowDowngrade;
    }

    public int hashCode() {
        return Objects.hash(this.maxVersionLevel, this.allowDowngrade);
    }

    public String toString() {
        return String.format("FeatureUpdate{maxVersionLevel:%d, allowDowngrade:%s}", this.maxVersionLevel, this.allowDowngrade);
    }
}

