/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin.internals;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.clients.admin.AbstractOptions;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.TopicPartition;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.InvalidMetadataException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.requests.MetadataResponse;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public final class MetadataOperationContext<T, O extends AbstractOptions<O>> {
    private final Collection<String> topics;
    private final O options;
    private final long deadline;
    private final Map<TopicPartition, KafkaFutureImpl<T>> futures;
    private Optional<MetadataResponse> response;

    public MetadataOperationContext(Collection<String> topics, O options, long deadline, Map<TopicPartition, KafkaFutureImpl<T>> futures) {
        this.topics = topics;
        this.options = options;
        this.deadline = deadline;
        this.futures = futures;
        this.response = Optional.empty();
    }

    public void setResponse(Optional<MetadataResponse> response) {
        this.response = response;
    }

    public Optional<MetadataResponse> response() {
        return this.response;
    }

    public O options() {
        return this.options;
    }

    public long deadline() {
        return this.deadline;
    }

    public Map<TopicPartition, KafkaFutureImpl<T>> futures() {
        return this.futures;
    }

    public Collection<String> topics() {
        return this.topics;
    }

    public static void handleMetadataErrors(MetadataResponse response) {
        for (MetadataResponse.TopicMetadata tm : response.topicMetadata()) {
            if (MetadataOperationContext.shouldRefreshMetadata(tm.error())) {
                throw tm.error().exception();
            }
            for (MetadataResponse.PartitionMetadata pm : tm.partitionMetadata()) {
                if (!MetadataOperationContext.shouldRefreshMetadata(pm.error)) continue;
                throw pm.error.exception();
            }
        }
    }

    public static boolean shouldRefreshMetadata(Errors error) {
        return error.exception() instanceof InvalidMetadataException;
    }
}

