/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.compress;

import cz.o2.proxima.kafka.shaded.com.github.luben.zstd.RecyclingBufferPool;
import cz.o2.proxima.kafka.shaded.com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import cz.o2.proxima.kafka.shaded.com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.KafkaException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.BufferSupplier;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ByteBufferInputStream;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ByteBufferOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ZstdFactory {
    private ZstdFactory() {
    }

    public static OutputStream wrapForOutput(ByteBufferOutputStream buffer) {
        try {
            return new BufferedOutputStream(new ZstdOutputStreamNoFinalizer((OutputStream)buffer, RecyclingBufferPool.INSTANCE), 16384);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    public static InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
        try {
            return new BufferedInputStream(new ZstdInputStreamNoFinalizer(new ByteBufferInputStream(buffer), RecyclingBufferPool.INSTANCE), 16384);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }
}

