/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.kafka.shaded.org.apache.kafka.common.message;

import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Message;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import cz.o2.proxima.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class AlterIsrRequestData
implements ApiMessage {
    int brokerId;
    long brokerEpoch;
    List<TopicData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The ID of the requesting broker"), new Field("broker_epoch", Type.INT64, "The epoch of the requesting broker"), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterIsrRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AlterIsrRequestData() {
        this.brokerId = 0;
        this.brokerEpoch = -1L;
        this.topics = new ArrayList<TopicData>(0);
    }

    @Override
    public short apiKey() {
        return 56;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.brokerId = _readable.readInt();
        this.brokerEpoch = _readable.readLong();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<TopicData> newCollection = new ArrayList<TopicData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicData(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        _writable.writeLong(this.brokerEpoch);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (TopicData topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(8);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (TopicData topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterIsrRequestData)) {
            return false;
        }
        AlterIsrRequestData other = (AlterIsrRequestData)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public AlterIsrRequestData duplicate() {
        AlterIsrRequestData _duplicate = new AlterIsrRequestData();
        _duplicate.brokerId = this.brokerId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
        for (TopicData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "AlterIsrRequestData(brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterIsrRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public AlterIsrRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public AlterIsrRequestData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public static class PartitionData
    implements Message {
        int partitionIndex;
        int leaderEpoch;
        List<Integer> newIsr;
        int currentIsrVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index"), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition"), new Field("new_isr", new CompactArrayOf(Type.INT32), "The ISR for this partition"), new Field("current_isr_version", Type.INT32, "The expected version of ISR which is being updated"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionData() {
            this.partitionIndex = 0;
            this.leaderEpoch = 0;
            this.newIsr = new ArrayList<Integer>(0);
            this.currentIsrVersion = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field newIsr was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.newIsr = newCollection;
            this.currentIsrVersion = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.leaderEpoch);
            _writable.writeUnsignedVarint(this.newIsr.size() + 1);
            for (Integer newIsrElement : this.newIsr) {
                _writable.writeInt(newIsrElement);
            }
            _writable.writeInt(this.currentIsrVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.newIsr.size() + 1));
            _size.addBytes(this.newIsr.size() * 4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.newIsr == null ? other.newIsr != null : !this.newIsr.equals(other.newIsr)) {
                return false;
            }
            if (this.currentIsrVersion != other.currentIsrVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.newIsr == null ? 0 : this.newIsr.hashCode());
            hashCode = 31 * hashCode + this.currentIsrVersion;
            return hashCode;
        }

        @Override
        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.leaderEpoch = this.leaderEpoch;
            ArrayList<Integer> newNewIsr = new ArrayList<Integer>(this.newIsr.size());
            for (Integer _element : this.newIsr) {
                newNewIsr.add(_element);
            }
            _duplicate.newIsr = newNewIsr;
            _duplicate.currentIsrVersion = this.currentIsrVersion;
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partitionIndex=" + this.partitionIndex + ", leaderEpoch=" + this.leaderEpoch + ", newIsr=" + MessageUtil.deepToString(this.newIsr.iterator()) + ", currentIsrVersion=" + this.currentIsrVersion + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> newIsr() {
            return this.newIsr;
        }

        public int currentIsrVersion() {
            return this.currentIsrVersion;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionData setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public PartitionData setNewIsr(List<Integer> v) {
            this.newIsr = v;
            return this;
        }

        public PartitionData setCurrentIsrVersion(int v) {
            this.currentIsrVersion = v;
            return this;
        }
    }

    public static class TopicData
    implements Message {
        String name;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the topic to alter ISRs for"), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicData() {
            this.name = "";
            this.partitions = new ArrayList<PartitionData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<PartitionData> newCollection = new ArrayList<PartitionData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionData(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionData partitionsElement = (PartitionData)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.name = this.name;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setName(String v) {
            this.name = v;
            return this;
        }

        public TopicData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }
}

